<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Complaints;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Contact;
use App\Http\Controllers\Controller;

class ComplaintsController extends Controller
{
    public function index()
    {

        $complaints = Complaints::orderBy('created_at', 'desc')->get();

        return view('adtrpanel.sikayet-takip.index', compact('complaints'));
    }

    public function form($id)
    {

        $complaint = Complaints::find($id);

        return view('adtrpanel.sikayet-takip.form', compact('complaint'));
    }

    public function save($id)
    {
        $comp = Complaints::where('complaint_id', $id)->first();
        if ($comp) {
            $comp->detail = request('detail');
            $comp->note = request('note');
            $comp->status = request('status');
            $comp->save();
            $ndata = ['message_variable' => 'success', 'message' => 'Sikayet Güncellendi'];
        } else {
            $ndata = ['message_variable' => 'error', 'message' => 'Bir Sorun Oluştu Tekrar Deneyin.'];
        }
        return redirect()->back()->with($ndata);
    }

    public function newComplaints()
    {

        if (request()->has('name') && request()->has('phone') && request()->has('subject') && request()->has('detail')) {

            if (!empty(request('name')) && !empty(request('subject')) && !empty(request('detail'))) {
                $comp = Complaints::create([
                    'name' => request('name'),
                    'phone' => request('phone'),
                    'subject' => request('subject'),
                    'detail' => request('detail'),
                    'note' => request('note'),
                    'status' => request('status')
                ]);

                if ($comp) {
                    $route = route('adtrpanel.sikayet-takip.show', $comp->complaint_id);
                    return response()->json(['result' => 'success', 'redirect_url' => $route]);
                }
            } else {

                return response()->json(['result' => "error", 'message' => "* Bulunan Alanları Doldurun!"]);
            }


        }

        return response()->json(['result' => "error", 'message' => "Boş Alan Bırakmayın."]);
    }

    public function delete(){

        if (\request()->has('id')){
            $comp = Complaints::find(request('id'));
            if ($comp){
                $comp->delete();
                return response()->json(['result' => 'success','id'=> \request('id')]);
            }

        }

    }

}



