<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Comment;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class CommentController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'read'));
        $comments = Comment::paginate(15);

        return view('adtrpanel.comments.comments', compact('comments'));
    }

    public function delete($comment_id){
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'delete'));
        Comment::where('comment_id',$comment_id)->delete();
        return redirect()->back();
    }

    public function commentform($comment_id){

        $comment = Comment::where('comment_id',$comment_id)->first();
        $upcomment = Comment::where('upcomment_id',$comment_id)->first();
        return view('adtrpanel.comments.commentform',compact('comment','upcomment'));
    }

    public function save($comment_id){
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'update'));
        Comment::create([
           'language_id'     => request('language_id'),
           'comment'         => request('upcomment'),
           'upcomment_id'    =>  $comment_id,
           'status'        => 1
        ]);

        return redirect()->route('adtrpanel.comments');
    }

    public function update($comment_id){

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'update'));
        Comment::where('upcomment_id', $comment_id)->update([
            'comment' => request('upcomment'),
            'language_id'     => request('language_id'),
            'status'        => 1
        ]);

        return redirect()->route('adtrpanel.comments');
    }

    public function activated($comment_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'update'));
         Comment::where('comment_id',$comment_id)->update([
                'status' => 1
        ]);
        return redirect()->back();
    }

    public function deactivated($comment_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Comment', 'update'));
        Comment::where('comment_id',$comment_id)->update([
            'status' => 0
        ]);
        return redirect()->back();
    }

}
