<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Category;
use App\Models\CategoryDetail;
use App\Models\Language;
use App\Models\NewsDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;

class CategoryController extends Controller
{

    public function categories()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'read'));
        request()->flash();
        if (request('aranan')) {
            $aranan = request('aranan');
            $categories = CategoryDetail::Where('category_name', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')->groupBy('category_id')->paginate(15);
        } else {
            $categories = CategoryDetail::orderBy('category_name', 'desc')->groupBy('category_id')->paginate(15);
        }

        return view('adtrpanel.category.categories', compact('categories'));
    }

    public function newsForm($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'update'));
            $category = CategoryDetail::where('category_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'create'));
        }

        $languages = Language::all();
        return view('adtrpanel.category.categoryform', compact('category', 'languages'));
    }

    public function delete($category_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'delete'));
        $news = Category::find($category_id);
        $news->delete();
        return redirect()->route('adtrpanel.categories');
    }

    public function save($category_id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($category_id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Category', 'create'));
        }

        $create_category = Category::updateOrCreate(
            ['category_id' => $category_id]
        )->category_id;

        $languages = Language::all();

        $datas = request()->only('category_name', 'category_meta_title', 'category_meta_description', 'slug','category_image','category_description');
        if (count($languages) > 0) {
            foreach ($languages as $language) {

                if (!empty($datas['category_image'][$language->language_short_name]) || !empty($datas['category_name'][$language->language_short_name]) || !empty($datas['category_meta_title'][$language->language_short_name]) || !empty($datas['category_meta_description'][$language->language_short_name])) {

                    if(isset($datas['category_image'][$language->language_short_name])){
                        $img = \Image::make($datas['category_image'][$language->language_short_name]);
                        $resim = $datas['category_image'][$language->language_short_name];

                        $img->fit(800, 450);
                        $path = 'uploads/fotogaleri/' . 'foto' . rand() . '.' . $resim->getClientOriginalName();
                        $img->save(public_path($path));
                    }


                    $create_category_details = CategoryDetail::updateOrCreate(
                        [
                            'category_id' => $create_category,
                            'language_id' => $language->language_id,
                        ],
                        [
                            'category_name' => $datas['category_name'][$language->language_short_name],
                            'category_meta_title' => $datas['category_meta_title'][$language->language_short_name],
                            'category_meta_description' => $datas['category_meta_description'][$language->language_short_name],
                            'category_description' => $datas['category_description'][$language->language_short_name]

                        ]
                    )->category_details_id;


                    if (!empty($datas['slug'][$language->language_short_name])) {
                        $slug = $datas['slug'][$language->language_short_name];
                    } else {
                        $slug = str_slug($datas['category_name'][$language->language_short_name]);
                    }
                    $slug = str_slug($datas['category_name'][$language->language_short_name]);
                    if (categorySlugKontrol($slug) != 0) {
                        $cat_slugs = CategoryDetail::whereSlug($slug)->get();
                        foreach ($cat_slugs as $cat_slug) {
                            if ($cat_slug->category_id != $category_id) {
                                $slug = $slug . '-' . (categorySlugKontrol($slug) + 1);
                            }
                        }
                    }

                    $add_slug = CategoryDetail::where('category_details_id', $create_category_details)->update(['slug' => $slug]);

                }

            }

        }

        return redirect()->route('adtrpanel.categories');

        /*if(categorySlugKontrol(str_slug(request('category_name'))) == 0)
        {
            $slug = str_slug(request('category_name'));
        } else {
            $slug= str_slug(request('category_name')) . '-' . (categorySlugKontrol(str_slug(request('category_name')))+1);
        }*/

    }

    public function autocomplete(){



        if (!empty(\request()->get('filter_name'))) {

            $json = array();

            $category_results = CategoryDetail::where('category_name',\request()->get('filter_name'))->orWhere('category_name','like','%'.\request()->get('filter_name').'%')->get();

            foreach ($category_results as $category_results){
                $json[] = array(
                    'category_id' => $category_results->category_id,
                    'name'        => $category_results->category_name
                );
            }

            $sort_order = array();

            foreach ($json as $key => $value) {
                $sort_order[$key] = $value['name'];
            }

            array_multisort($sort_order, SORT_ASC, $json);
            return \Response::json($json);

        }
    }
}

