<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\BlogDetail;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;

class BlogController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'read'));
        $blog_list = BlogDetail::groupBy('blog_id')->paginate(15);
        return view('adtrpanel.blogs.index', compact('blog_list'));
    }

    public function blogForm($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'update'));
            $blogs = BlogDetail::where('blog_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'create'));
        }
        $languages = Language::all();
        return view('adtrpanel.blogs.blogform', compact('blogs', 'languages'));
    }

    public function save($id = null)
    {

        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'create'));
        }

        $general_datas = request()->only('blog_title', 'blog_content', 'status', 'rank');
        $meta_datas = request()->only('blog_meta_title', 'blog_meta_description', 'blog_meta_keywords', 'orginal_slug', 'slug','seo_description');
        $image_datas = request()->only('image', 'alt_and_title');

        // Oluşturulan blogun idsini al
        $globBlogID= null;
        if ($id != null) {
            $blog_id = $id;
        } else {
            $addBlog = Blog::insert(['created_at' => date('Y-m-d'), 'updated_at' => date('Y-m-d')]);
            if (!$addBlog) {
                dd('ErR add $addBlog');
            }
            $checkBlg = Blog::orderByDesc('blog_id')->first();
            $blog_id = $checkBlg->blog_id;
        }

        $languages = Language::all();
        if(count($languages) > 0){
            foreach ($languages as $language) {

                if (!empty($general_datas['blog_title'][$language->language_short_name]) && !empty($general_datas['blog_content'][$language->language_short_name]) )  {

                    $globBlogID = $blog_id;

                    if (empty($general_datas['rank'][$language->language_short_name])) {
                        $checkLastBlogRank = BlogDetail::orderByDesc('blog_details_id')->first();
                        if ($checkLastBlogRank) {
                            $general_datas['rank'][$language->language_short_name] =
                                (int)$checkLastBlogRank->rank + 1;
                        } else {
                            $general_datas['rank'][$language->language_short_name] = 1;
                        }
                    }
                    $create_blog_detail = BlogDetail::updateOrCreate(
                        [
                            'blog_id' => $blog_id,
                            'language_id' => $language->language_id
                        ],
                        [
                            'blog_title' => $general_datas['blog_title'][$language->language_short_name],
                            'blog_content' => $general_datas['blog_content'][$language->language_short_name],
                            'status' => $general_datas['status'][$language->language_short_name],
                            'rank' => $general_datas['rank'][$language->language_short_name],
                        ]
                    );

                    if(!$create_blog_detail){
                        dd('$create_blog_detail err');
                    }

                    $meta_data = [
                        'blog_meta_title' => $meta_datas['blog_meta_title'][$language->language_short_name],
                        'blog_meta_description' => $meta_datas['blog_meta_description'][$language->language_short_name],
                        'blog_meta_keywords' => $meta_datas['blog_meta_keywords'][$language->language_short_name],
                        'slug' => $meta_datas['slug'][$language->language_short_name],
                        'seo_description' => $meta_datas['seo_description'][$language->language_short_name]
                    ];

                    if (empty($meta_datas['slug'][$language->language_short_name])) {

                        $meta_data['slug'] = str_slug($general_datas['blog_title'][$language->language_short_name]);

                    }

                    $push_meta_datas = BlogDetail::where('blog_details_id', $create_blog_detail->blog_details_id)->update($meta_data);
                }
            }
            do_action('adtrpanel.save.after', ['datas' => request()->all(), 'parameter' => 'blog_id', 'id' => $blog_id]);

        }

        if (request()->hasFile('image')) {
            $this->validate(request(), [
                    'image' => 'image|mimes:jpg,jpeg,png|max:2048'
                ]
            );
            $resim = request()->file('image');
            $file_rand_name = rand();
            $yeni = public_path('uploads/blogs/' . $file_rand_name . '-850x400.' . $resim->getClientOriginalExtension());
            $i = 1;
            for (; file_exists($yeni);) {
                $yeni = public_path('uploads/blogs/' . $file_rand_name . '-' . $i . '-850x400.' . $resim->getClientOriginalExtension());
                $i++;
            }
            if ($resim->isValid()) {
                Image::make(request()->file('image'))->fit(850, 400)->save($yeni);
                $dosya = str_replace(public_path(), '', $yeni);
            }

            $blog_image = $dosya;
            if($globBlogID !=null){
                $push_image_datas = BlogDetail::where('blog_id', $globBlogID)->update(['image' => $blog_image, 'alt_and_title' => $image_datas['alt_and_title']]);

            }
        } else {
            $check = BlogDetail::where('blog_id', $globBlogID)->first();
            if($globBlogID!=null){
                $push_image_datas = BlogDetail::where('blog_id', $globBlogID)->update(['image' => $check->image, 'alt_and_title' => $check->alt_and_title]);
            }
        }

        return redirect()->route('adtrpanel.blogs');

    }

    public function delete($blog_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'delete'));
        $blog_detail = BlogDetail::where('blog_id', $blog_id)->first();

        if(\File::exists(public_path($blog_detail->image))){
                unlink(public_path($blog_detail->image));
        }
        $blog_detail->delete();
        $blog = Blog::find($blog_id);
        $blog->delete();
        return redirect()->route('adtrpanel.blogs');
    }

    public function activated($blog_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blogs', 'update'));
        BlogDetail::where('blog_id', $blog_id)->update([
            'status' => 1
        ]);
        return redirect()->route('adtrpanel.blogs');
    }

    public function deactivated($blog_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Blog', 'update'));
        BlogDetail::where('blog_id', $blog_id)->update([
            'status' => 0
        ]);
        return redirect()->route('adtrpanel.blogs');
    }
}
