<?php


namespace App\Http\Controllers\Adtrpanel;


use App\Models\ArticleDetail;

use App\Models\Authors;
use App\Models\CategoryDetail;

use App\Models\Language;

use App\Models\MedicalStaff;
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Models\Article;

use App\Models\User;

use App\Models\Category;

use Illuminate\Support\Facades\Validator;

use Intervention\Image\Facades\Image;


class ArticleController extends Controller

{

    public function index()

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'read'));

        $article_list = ArticleDetail::where('language_id', 1)->groupBy('article_id')->orderBy('article_id', 'desc')->paginate();

        return view('adtrpanel.articles.index', compact('article_list'));

    }


    public function articleForm($id = null)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'update'));

            $article = ArticleDetail::where('article_id', $id)->get();

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'create'));

        }

        $categories = CategoryDetail::all();

        $languages = Language::all();
        $authors = MedicalStaff::where('type', 'doctor')->get();

        return view('adtrpanel.articles.articleform', compact('article', 'categories', 'languages', 'authors'));

    }


    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'create'));
        }

        $general_datas = request()->only('article_title', 'article_content', 'status', 'category_id', 'rank', 'author');
        $meta_datas = request()->only('article_meta_title', 'article_meta_description', 'article_meta_keywords', 'orginal_slug', 'slug');
        $image_datas = request()->only('image', 'alt_and_title');
        $published_at = date("Y-m-d H:i:s", strtotime(request('published_at')));

        $languages = Language::all();

        $create_article = Article::updateOrCreate(
            [
                'article_id' => $id
            ],
            [
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        )->article_id;

        if (!empty($create_article)) {

            foreach ($languages as $language) {

                if (
                    !empty($general_datas['article_title'][$language->language_short_name]) &&
                    !empty($general_datas['article_content'][$language->language_short_name]) &&
                    !empty($general_datas['category_id'][$language->language_short_name]))
                {

                    if (!empty($published_at)) {
                        $general_datas['status'][$language->language_short_name] = 0;
                    }

                    $create_article_detail = ArticleDetail::updateOrCreate(
                        [
                            'article_id' => $create_article,
                            'language_id' => $language->language_id
                        ],
                        [
                            'article_title' => $general_datas['article_title'][$language->language_short_name],
                            'article_content' => $general_datas['article_content'][$language->language_short_name],
                            'status' => $general_datas['status'][$language->language_short_name],
                            'category_id' => $general_datas['category_id'][$language->language_short_name],
                            'rank' => $general_datas['rank'][$language->language_short_name],
                            'author' => $general_datas['author'],
                            'published_at' => $published_at
                        ]
                    )->article_details_id;

                    if (empty($meta_datas['slug'][$language->language_short_name])) {
                        $meta_data['slug'] = str_slug($general_datas['article_title'][$language->language_short_name]);
                    }

                    $push_meta_datas = ArticleDetail::where('article_details_id', $create_article_detail)->update([
                        'article_meta_title' => $meta_datas['article_meta_title'][$language->language_short_name],
                        'article_meta_description' => $meta_datas['article_meta_description'][$language->language_short_name],
                        'article_meta_keywords' => $meta_datas['article_meta_keywords'][$language->language_short_name],
                        'slug' => $meta_datas['slug'][$language->language_short_name]
                    ]);

                    if (request()->hasFile('image')) {
                        $this->validate(
                            request(),
                            [
                                'image' => 'image|mimes:jpg,jpeg,png|max:2048'
                            ]
                        );
                        $resim = request()->file('image');
                        $file_rand_name = rand();
                        $yeni = public_path('uploads/articles/' . $file_rand_name . '-850x400.' . $resim->getClientOriginalExtension());
                        $i = 1;
                        for (; file_exists($yeni);) {
                            $yeni = public_path('uploads/articles/' . $file_rand_name . '-' . $i . '-850x400.' . $resim->getClientOriginalExtension());
                            $i++;
                        }

                        if ($resim->isValid()) {
                            Image::make(request()->file('image'))->fit(800, 450)->save($yeni);
                            $dosya = str_replace(public_path(), '', $yeni);
                        }

                        $article_image = $dosya;

                    }

                    if (empty($article_image)) {
                        //current image
                        $article_image = ArticleDetail::select('image')->where('article_id', $create_article)->first();
                        $article_image = $article_image->image;
                    }

                    $push_image_datas = ArticleDetail::where('article_id', $create_article)->update(['image' => $article_image ?? null, 'alt_and_title' => $image_datas['alt_and_title']]);

                }

            }

            do_action('adtrpanel.save.after', ['datas' => request()->all(), 'parameter' => 'article_id', 'id' => $create_article]);
            do_action('adtrpanel.information_save.after', ['datas' => request()->all(), 'parameter' => 'article_id', 'id' => $create_article]);

        }

        return redirect()->route('adtrpanel.articles.edit', $create_article);

    }


    public function delete($article_id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'delete'));

        $article_detail = ArticleDetail::where('article_id', $article_id)->first();


        if (!empty($article_detail->image)) {

            $image_path = public_path($article_detail->image);

            unlink($image_path);

        }

        $article = Article::find($article_id);

        $article->delete();

        return redirect()->route('adtrpanel.articles');

    }


    public function activated($article_id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'update'));

        ArticleDetail::where('article_id', $article_id)->update([

            'status' => 1

        ]);

        return redirect()->route('adtrpanel.articles');

    }


    public function deactivated($article_id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Article', 'update'));

        ArticleDetail::where('article_id', $article_id)->update([

            'status' => 0

        ]);

        return redirect()->route('adtrpanel.articles');

    }

}

