<?php
namespace App\Http\Controllers\Adtrpanel;
use App\Models\AppointmentSubject;
use App\Models\AppointmentSubjectDetail;
use App\Models\Language;
use App\Models\Randevu;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
class AppointmentController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'read'));
        request()->flash();
        if (request('aranan')) {
            $aranan = request('aranan');
            $appointments = Randevu::Where('adsoyad', 'like', '%' . $aranan . '%')->orderByDesc('created_at')->where('status', 0)->paginate(15);
        } else {
            $appointments = Randevu::orderByDesc('randevu_id')->where('status', 0)->paginate(15);
        }

        return view('adtrpanel.appointment.appointments', compact('appointments'));
    }

    public function read()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'read'));
        request()->flash();
        if (request('aranan')) {
            $aranan = request('aranan');
            $appointments = Randevu::Where('adsoyad', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')->groupBy('category_id')->paginate(15);
        } else {
            $appointments = Randevu::orderByDesc('randevu_id')->where('status', 1)->paginate(15);
        }

        return view('adtrpanel.appointment.appointments', compact('appointments'));
    }

    public function activated($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'update'));
        Randevu::where('randevu_id', $id)->update(['status' => 1]);
        return redirect()->route('adtrpanel.appointments.read');
    }

    public function deactivated($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'update'));
        Randevu::where('randevu_id', $id)->update(['status' => 0]);
        return redirect()->route('adtrpanel.appointments');
    }

    public function subjects()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('AppointmentSubject', 'read'));
        request()->flash();
        if (request('aranan')) {
            $aranan = request('aranan');
            $subjects = AppointmentSubjectDetail::Where('name', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')->groupBy('subject_id')->paginate(15);
        } else {
            $subjects = AppointmentSubjectDetail::orderBy('name', 'desc')->groupBy('subject_id')->paginate(15);
        }

        return view('adtrpanel.appointment.subjects', compact('subjects'));
    }

    public function subadd($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('AppointmentSubject', 'update'));
            $appointmentSubjects = AppointmentSubjectDetail::where('subject_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('AppointmentSubject', 'create'));
        }

        $languages = Language::all();
        return view('adtrpanel.appointment.addsubject', compact( 'languages','appointmentSubjects'));
    }

    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if($id != null)
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('AppointmentSubjectDetail', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('AppointmentSubjectDetail', 'create'));
        }

        $createAppointment = AppointmentSubject::updateOrCreate(
            ['subject_id' => $id]
        )->subject_id;

        $languages = Language::all();
        $datas = request()->only('name', 'rank','status', 'language_id');
        if(count($languages) > 0 ){
            foreach ($languages as $language) {

                if(!empty($datas['name'][$language->language_short_name]) || !empty($datas['status'][$language->language_short_name])) {

                    if (empty($datas['rank'][$language->language_short_name])) {
                        $checkLastRank = AppointmentSubjectDetail::orderByDesc('subject_detail_id')->first();
                        if ($checkLastRank) {
                            $datas['rank'][$language->language_short_name] =
                                (int)$checkLastRank->rank + 1;
                        } else {
                            $datas['rank'][$language->language_short_name] = 1;
                        }
                    }

                    $createAppointmentDetail = AppointmentSubjectDetail::updateOrCreate(
                        [
                            'subject_id' => $createAppointment,
                            'language_id' => $language->language_id,
                        ],
                        [
                            'name' => $datas['name'][$language->language_short_name],
                            'status' => $datas['status'][$language->language_short_name],
                            'rank' => $datas['rank'][$language->language_short_name],
                            'language_id' => $language->language_id,
                        ]
                    )->subject_detail_id;
                }
            }
        }

        return redirect()->route('adtrpanel.appointments.subjects');
    }

    public function delete($randevu_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'delete'));
        $randevu = Randevu::where('randevu_id', $randevu_id)->delete();
        if(!$randevu){
            dd('ER');
        }

        return redirect()->route('adtrpanel.appointments');
    }

    public function sub_activated($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'update'));
        if(AppointmentSubjectDetail::where('subject_id', $id)->update(['status' => 1])){
            return redirect()->route('adtrpanel.appointments.subjects');
        }
    }

    public function sub_deactivated($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'update'));
        if(AppointmentSubjectDetail::where('subject_id', $id)->update(['status' => 0])){
            return redirect()->route('adtrpanel.appointments.subjects');
        }
    }

    public function sub_delete($subject_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Randevu', 'delete'));
        $appointmentSubject = AppointmentSubject::where('subject_id', $subject_id)->delete();
        if(!$appointmentSubject){
            dd('ER $appointmentSubject');
        }
        return redirect()->route('adtrpanel.appointments.subjects');
    }

}