<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Article;
use App\Models\ArticleDetail;
use App\Models\Emails;
use App\Models\Language;
use App\Models\MenuDetail;
use App\Models\BlogDetail;
use App\Models\Notification;
use App\Models\Product;
use App\Models\ProductDetail;
use App\Models\ImageGallery;
use test\Mockery\MockClassWithFinalWakeupTest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Analytics;
use Spatie\Analytics\Period;

class AjaxController extends Controller
{
    public function notifications()
    {
        if (Auth::guard('adtrpanel')->check()) {
            if (request()->ajax()) {
                // Notifications
                $notifications_count = Notification::where('destination', Auth::guard('adtrpanel')->user()->id)->where('status', '0')->count();
                if ($notifications_count == 0) {
                    $notifications_count = '0';
                }
                return response()->json(array('notifications' => $notifications_count, 'bildirim' => ['baslik1' => '3 Saat Önce', 'baslik2' => '5 Saat önce']));
            } else {
                return response()->json(array('error' => 1));
            }
        } else {
            return response()->json(array('error' => 1));
        }
    }

    public function productSearch(){

        $data = '';

        $name = \request('name');

       if($name != '')
            $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->where('name','like','%'.$name.'%')->get();
       else
            $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->get();



       if(count($products) > 0){

            foreach ($products as $product){
                $data .=
                    '<tr>
                         <td class="text-center">
                            <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            </label>
                         </td>
                         <td>'.$product->name.'</td>
                         <td>'.$product->model.'</td>
                         <td>'.$product->price.'</td>';

                    if($product->status == 1){
                $data .= '<td>
                            <span class="badge badge-success">Aktif</span>
                          </td>';
                    }else{
                $data .=  '<td><span class="badge badge-danger">Pasif</span></td>';
                    }

                $data.='
                           <td>
                                <a href="'.route('adtrpanel.product.delete',$product->id).'">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="'.route('adtrpanel.product.edit',$product->id).'">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i>Düzenle
                                    </button>
                                </a>';
                       if($product->status == 0) {
               $data .=         '<a href="' . route('adtrpanel.product.activated', $product->id) . '">
                                    <button class="btn btn-dark btn-sm">
                                        <i class="fas fa-lock-open"></i>Aktif Et
                                    </button>
                                 </a>';
                       }else{
               $data .=        '<a href="'.route('adtrpanel.product.deactivated',$product->id).'">
                                    <button class="btn btn-warning btn-sm">
                                        <i class="fas fa-lock"></i>Pasif Et
                                    </button>
                                 </a>';
                                }

               $data .= '</td>
                       </tr>';
            }
        }
        return $data;
    }
    public function productNameSortOrder(){

        $data ='';
        if(\request('order') == 1)
            $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->orderby('name','asc')->get();
        else
            $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->orderByDesc('name')->get();

        foreach ($products as $product){

            $data .=
                     '<tr>
                         <td class="text-center">
                            <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes">
                            </label>
                         </td>
                         <td>'.$product->name.'</td>
                         <td>'.$product->model.'</td>
                         <td>'.$product->price.'</td>';

            if($product->status == 1){
                $data .= '<td>
                            <span class="badge badge-success">Aktif</span>
                          </td>';
            }else{
                $data .=  '<td><span class="badge badge-danger">Pasif</span></td>';
            }
                $data.='
                           <td>
                                <a href="'.route('adtrpanel.product.delete',$product->id).'">
                                    <button class="btn btn-danger btn-sm">
                                        <i class="fa fa-times"></i> Sil
                                    </button>
                                </a>
                                <a href="'.route('adtrpanel.product.edit',$product->id).'">
                                    <button class="btn btn-success btn-sm">
                                        <i class="fa fa-edit"></i>Düzenle
                                    </button>
                                </a>';
            if($product->status == 0) {
                $data .=         '<a href="' . route('adtrpanel.product.activated', $product->id) . '">
                                    <button class="btn btn-dark btn-sm">
                                        <i class="fas fa-lock-open"></i>Aktif Et
                                    </button>
                                 </a>';
            }else{
                $data .=        '<a href="'.route('adtrpanel.product.deactivated',$product->id).'">
                                    <button class="btn btn-warning btn-sm">
                                        <i class="fas fa-lock"></i>Pasif Et
                                    </button>
                                 </a>';
            }

            $data .= '</td>
                       </tr>';

        }

        return $data;

    }

    public function blogara()
    {
        $data = '';
        request()->flash();
        if (request()->filled('aranan')) {
            $aranan = request('aranan');
            $blogs = BlogDetail::
                Where('blog_title', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')->paginate(15);
        } else {
            $blogs = BlogDetail::orderByDesc('created_at')->paginate(15);
        }


        if (count($blogs) > 0) {
            foreach ($blogs as $blog) {
                $data .= '<tr><td class="text-center"><label class="mt-checkbox mt-checkbox-single mt-checkbox-outline"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes"><span></span></label></td><td><img src="' . $blog->image . '" width="125" alt="' . $blog->alt_and_title . '" /></td><td>' . $blog->blog_title . '</td><td>' . $blog->rank . '</td><td>';
                if ($blog->status) {
                    $data .= '<span class="badge badge-success">' . trans('admin.active') . '</span>';
                } else {
                    $data .= '<span class="badge badge-danger">' . trans('admin.passive') . '</span></td>';
                }
                $data .= '</td><td><a href="' . route('adtrpanel.blogs.delete', $blog->blog_id) . '"><button class="btn btn-danger btn-sm"><i class="fa fa-times"></i> Sil</button></a><a href="' . route('adtrpanel.blogs.edit', $blog->blog_id) . '"><button class="btn btn-success btn-sm"><i class="fa fa-edit"></i> Düzenle</button></a>';
                if ($blog->status) {
                    $data .= '<a href="' . route('adtrpanel.blogs.activated', $blog->blog_id) . '"><button class="btn btn-warning btn-sm"><i class="fas fa-lock"></i>' . trans('admin.deactivated') . '</button></a>';
                } else {
                    $data .= '<a href="' . route('adtrpanel.blogs.deactivated', $blog->blog_id) . '"><button class="btn btn-dark btn-sm"><i class="fas fa-lock-open"></i>' . trans('admin.activated') . '</button></a>';
                }
                $data .= '<a href="' . str_replace('/-','-',route('blog', $blog->slug))  . '"><button class="btn btn-info btn-sm"><i class="fa fa-eye"></i> Görüntüle</button></a>';
            }
            $data .= '<tr> <td colspan="9">' . $blogs->setPath(route('adtrpanel.blogs'))->appends(['aranan' => old('aranan')])->links() . '</td> </tr>';
        } else {
            $data .= '<tr class="odd gradeX"><td colspan="9">' . trans('admin.no_blogs_found') . '</td></tr>';
        }
        request()->flash();
        return $data;
    }

     public function articleara()
    {
        $data = '';
        request()->flash();
        if (request()->filled('aranan') || request('language_id')) {
            $aranan = request('aranan');
            $articles = ArticleDetail::
                Where('article_title', 'like', '%' . $aranan . '%')->where('language_id', request('language_id'))
                ->orderByDesc('created_at')->paginate(15);
        } else {
            $articles = ArticleDetail::orderByDesc('created_at')->paginate(15);
        }

        if (count($articles) > 0) {
            foreach ($articles as $article) {
                $data .= '<tr><td class="text-center"><label class="mt-checkbox mt-checkbox-single mt-checkbox-outline"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes"><span></span></label></td><td><img src="' . $article->image . '" width="250" alt="' . $article->alt_and_title . '" /></td><td>' . $article->article_title . '</td><td>'.$article->getCategory($article->category_id, $article->language_id)->category_name.'</td><td>' . $article->rank . '</td><td>';
                if ($article->status) {
                    $data .= '<span class="badge badge-success">' . trans('admin.active') . '</span>';
                } else {
                    $data .= '<span class="badge badge-danger">' . trans('admin.passive') . '</span></td>';
                }
                $data .= '</td><td><a href="' . route('adtrpanel.articles.delete', $article->article_id) . '"><button class="btn btn-danger btn-sm"><i class="fa fa-times"></i> Sil</button></a><a href="' . route('adtrpanel.articles.edit', $article->article_id) . '"><button class="btn btn-success btn-sm"><i class="fa fa-edit"></i> Düzenle</button></a>';
                if ($article->status) {
                    $data .= '<a href="' . route('adtrpanel.articles.activated', $article->article_id) . '"><button class="btn btn-warning btn-sm"><i class="fas fa-lock"></i>' . trans('admin.deactivated') . '</button></a>';
                } else {
                    $data .= '<a href="' . route('adtrpanel.articles.deactivated', $article->article_id) . '"><button class="btn btn-dark btn-sm"><i class="fas fa-lock-open"></i>' . trans('admin.activated') . '</button></a>';
                }
                $data .= '<a href="' . route('article', ['category_slug'=>$article->category->slug,'slug'=>$article->slug]) . '"><button class="btn btn-info btn-sm"><i class="fa fa-eye"></i> Görüntüle</button></a>';
            }
            $data .= '<tr> <td colspan="9">' . $articles->setPath(route('adtrpanel.articles'))->appends(['aranan' => old('aranan')])->links() . '</td> </tr>';
        } else {
            $data .= '<tr class="odd gradeX"><td colspan="9">' . trans('admin.no_articles_found') . '</td></tr>';
        }
        request()->flash();
        return $data;
    }

    public function kategoriara()
    {
        $data = '';
        request()->flash();
        if (request()->filled('aranan')) {
            $aranan = request('aranan');
            $categories = Category::Where('category_name', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')->paginate(15);
        } else {
            $categories = Category::orderByDesc('category_name')->paginate(15);
        }

        if (count($categories) > 0) {
            foreach ($categories as $category) {
                $data .= '<tr><td class="text-center"><label class="mt-checkbox mt-checkbox-single mt-checkbox-outline"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes"><span></span></label></td><td>' . $category->category_name . '</td><td>';

                $data .= '</td><td><a href="' . route('adtrpanel.news.delete', $category->category_id) . '"><button class="btn btn-danger btn-sm"><i class="fa fa-times"></i> Sil</button></a><a href="' . route('adtrpanel.news.edit', $category->category_id) . '"><button class="btn btn-success btn-sm"><i class="fa fa-edit"></i> Düzenle</button></a>';

                $data .= '<a href="' . route('news', $category->slug) . '"><button class="btn btn-info btn-sm"><i class="fa fa-eye"></i> Görüntüle</button></a>';
            }
            $data .= '<tr> <td colspan="9">' . $categories->setPath(route('adtrpanel.ctaegory'))->appends(['aranan' => old('aranan')])->links() . '</td> </tr>';
        } else {
            $data .= '<tr class="odd gradeX"><td colspan="9">' . trans('admin.no_blogs_found') . '</td></tr>';
        }
        request()->flash();
        return $data;
    }

    public function galeriresmiekle()
    {
        if (request()->hasFile('file')) {
            $datas = request()->only('file');
            $validator = Validator::make($datas, ['file' => 'image|mimes:jpg,jpeg,png|max:2048']);
            if ($validator->fails()) {
                $errors = $validator->errors();
                $data = "<tr><td colspan=\"4\">" . request('file') . " Adlı Dosya İzin Verilen Maksimum Değerlerin Dışında Olduğundan eklenemedi.</td></tr>";
            } else {
                $resim = request()->file('file');
                $image_info = getimagesize($_FILES["file"]["tmp_name"]);
                $image_width = $image_info[0];
                $image_height = $image_info[1];
                $image_name = str_replace($resim->extension(), '', $resim->getClientOriginalName());
                $dosyaAdi = str_slug($image_name);
                $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/fotogaleri/' . $dosyaAdi . '-' . $image_width . 'x' . $image_height . '.' . $resim->extension();
                $i = 1;
                for (; file_exists($yeni);) {
                    $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/fotogaleri/' . $dosyaAdi . '-' . $i . '-' . $image_width . 'x' . $image_height . '.' . $resim->extension();
                    $i++;
                }
                $dosya = str_replace($_SERVER['DOCUMENT_ROOT'] . '/public/uploads/fotogaleri/', '', $yeni);
                if ($resim->isValid()) {
                    $resim->move('uploads/fotogaleri', $dosya);
                }
                $id = uniqid();
                $languages = Language::all();
                $data = '
                    <tr data-id="resim.$id" id="' . $id . '">
                        <td class="text-center">
                            <a href="" class="fancybox-button" data-rel="fancybox-button"><img class="img-fluid" src="/uploads/fotogaleri/' . $dosya . '" alt="" width="200"> </a>
                        </td>
                        <td>';
                foreach ($languages as $language) {
                    $data .= '
                                    <div class="row mb-2">
                                        <div class="col-lg-2">
                                            <img src="' . $language->language_image . '" class="img-thumbnail rounded mx-auto d-block" width="55" alt="">
                                        </div>
                                        <div class="col-lg-10">
                                            <input type="text" name="title[' . $language->language_short_name . ']" autocomplete="off" class="form-control" placeholder="' . $language->language_details . ' Title Bilgisi" value="">
                                        </div>
                                    </div>
                                ';
                }
                $data .= '</td>
                        <td>
                            <input type="text" class="form-control" name="rank" placeholder="Sıra" value="" />
                            <input type="hidden" name="image" value="/uploads/fotogaleri/' . $dosya . '">
                        </td>
                        <td>
                            <button class="btn red-mint btn-outline sbold uppercase" id="resimkaldir"><i class="far fa-trash-alt"></i></button>
                        </td>
                    </tr>
                ';
            }
        } else {
            $data = "<tr><td colspan=\"4\">Dosya İzin Verilen Maksimum Değerlerin Dışında Olduğundan eklenemedi.</td></tr>";
        }
        return $data;
    }

    public function galeriresmisil()
    {
        $image_id = request('image_id');
        ImageGallery::destroy($image_id);
        return 'ok';
    }

    public function makaleara()
    {
        unset($sonuclar);
        $aranan = request('kelime');
        if ($aranan != '') {
            $sonuclar = ArticleDetail::where('article_title', 'LIKE', '%' . $aranan . '%')->get();
            $div = '';
            foreach ($sonuclar as $sonuc) {
                $div .= "<div class='kelime' onClick='makaletamamla(\"" . $sonuc->article_id . "\")'>" . $sonuc->article_title . "</div>";
            }
        } else {
            $div = '';
        }
        return response()->json([
            'sonuc' => 'basarili',
            'deger' => $div
        ]);
    }

    public function sonmenuid()
    {
        if (request()->has(['menu_id', 'language_id'])) {
            $menu = MenuDetail::create([
                'menu_id' => request('menu_id'),
                'parent_id' => 0,
                'link' => '#',
                'menu' => 'Özel Bağlantı',
                'language_id' => \request('language_id')
            ]);
            return response()->json([
                'id' => $menu->menu_detail_id,
                'baslik' => 'Özel Bağlantı',

            ]);
        }
    }

    public function menuAra()
    {
        $data = '';
        request()->flash();
        if (request()->filled('aranan')) {
            $aranan = request('aranan');
            $menu_list = Menu::Select('menu_name')
                ->where('menu_name', 'like', '%' . $aranan . '%')
                ->orderByDesc('created_at')
                ->paginate(15);
        } else {
            $menu_list = Menu::orderByDesc('created_at')->paginate(15);
        }
        if (count($menu_list) > 0) {
            foreach ($menu_list as $menu) {
                $data .= '<tr><td class="text-center"><label class="mt-checkbox mt-checkbox-single mt-checkbox-outline"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes"><span></span></label></td><td>' . $menu->menu_name . '</td>';

                $data .= '<td><a href="' . route('adtrpanel.menus.delete', $menu->menu_id) . '"><button class="btn btn-danger btn-sm"><i class="fa fa-times"></i> Sil</button></a><a href="' . route('adtrpanel.menus.save', $menu->menu_id) . '"><button class="btn btn-success btn-sm"><i class="fa fa-edit"></i> Düzenle</button></a>';

            }
            $data .= ' <tr><td colspan="2" style="text-align: right;">' . trans('admin.selected_for') . '</td>
                        <td><select name="islem" onchange="this.form.submit()">
                             <option value="0" selected="selected">' . trans('admin.choose') . '</option>
                                <option value="sil">' . trans('admin.delete') . '</option>
                            </select>
                        </td></tr>';
            $data .= '<tr> <td colspan="9">' . $menu_list->setPath(route('adtrpanel.menus'))->appends(['aranan' => old('aranan')])->links() . '</td> </tr>';
        } else {
            $data .= '<tr class="odd gradeX"> <td colspan="9">Marka bulunamadı</td> </tr>';

        }
        request()->flash();
        return $data;
    }

    public function menusil()
    {
        if (request()->has('menu_detail_id')) {
            $menu_details = MenuDetail::find(request('menu_detail_id'));
            if ($menu_details) {
                MenuDetail::destroy($menu_details->menu_detail_id);
                MenuDetail::where('parent_id', $menu_details->menu_detail_id)->delete();
            }
            return 'ok';
        }
    }

    public function menukaydet()
    {
        $menuadi = request('menu_adi');
        $menuurl = request('menu_url');
        $targetp = request('target');
        $cssp = request('menu_css');
        $ikonp = request('menu_ikon');
        $menulist = json_decode(request('menulist'));
        $menu_id = request("menu_id");
        $language_id = request("language_id");
        $languAge = Language::where('language_id',$language_id)->first();
        unset($menulist[0]);
        foreach ($menulist as $menu) {
            if ($menu->parent_id == '' || $menu->parent_id == null || empty($menu->parent_id)) {
                $parent_id = 0;
            } else {
                $parent_id = $menu->parent_id;
            }
            if (!isset($menuurl[$languAge->language_short_name][$menu->item_id]) || $menuurl[$languAge->language_short_name][$menu->item_id] == '' || $menuurl[$languAge->language_short_name][$menu->item_id] == null || empty($menuurl[$languAge->language_short_name][$menu->item_id])) {
                $menu_url = '#';
            } else {
                $menu_url = $menuurl[$languAge->language_short_name][$menu->item_id];
            }
            if (!isset($menuadi[$languAge->language_short_name][$menu->item_id]) || $menuadi[$languAge->language_short_name][$menu->item_id] == '' || $menuadi[$languAge->language_short_name][$menu->item_id] == null || empty($menuadi[$languAge->language_short_name][$menu->item_id])) {
                $menu_adi = '';
            } else {
                $menu_adi = $menuadi[$languAge->language_short_name][$menu->item_id];
            }
            if (!isset($targetp[$languAge->language_short_name][$menu->item_id]) || $targetp[$languAge->language_short_name][$menu->item_id] == '' || $targetp[$languAge->language_short_name][$menu->item_id] == null || empty($targetp[$languAge->language_short_name][$menu->item_id])) {
                $target = '_self';
            } else {
                $target = $targetp[$languAge->language_short_name][$menu->item_id];
            }
            if (!isset($cssp[$languAge->language_short_name][$menu->item_id]) || $cssp[$languAge->language_short_name][$menu->item_id] == '' || $cssp[$languAge->language_short_name][$menu->item_id] == null || empty($cssp[$languAge->language_short_name][$menu->item_id])) {
                $css = null;
            } else {
                $css = $cssp[$languAge->language_short_name][$menu->item_id];
            }
            if (!isset($ikonp[$languAge->language_short_name][$menu->item_id]) || $ikonp[$languAge->language_short_name][$menu->item_id] == '' || $ikonp[$languAge->language_short_name][$menu->item_id] == null || empty($ikonp[$languAge->language_short_name][$menu->item_id])) {
                $ikon = null;
            } else {
                $ikon = $ikonp[$languAge->language_short_name][$menu->item_id];
            }
            MenuDetail::updateOrCreate(
                [
                    'menu_detail_id' => $menu->item_id,
                    'menu_id' => $menu_id
                ],
                [
                    'parent_id' => $parent_id,
                    'link' => $menu_url,
                    'menu' => $menu_adi,
                    'sira' => $menu->left,
                    'target' => $target,
                    'css' => $css,
                    'icon' => $ikon,
                    'language_id'   => $language_id
                ]
            );
        }
        return 'ok';
    }

    public  function emails(){
        $emails = Emails::all();
        return view('adtrpanel.mails',compact('emails'));
    }

    public  function emailsjson(){
        $emails = Emails::all();
        echo json_encode($emails);

    }

    public function emaildelete($id)
    {
        Emails::where('id',$id)->delete();
        return redirect()->route('adtrpanel.emails');
    }
}
