<?php

use Illuminate\Support\Str;

function categorySlugKontrol($slug)

{

    $result = \App\Models\CategoryDetail::whereSlug($slug)->get();

    return count($result);

}

function articleSlugKontrol($slug)

{

    $result = \App\Models\Article::whereSlug($slug)->get();

    return count($result);

}

function workSlugControl($slug)
{
    $result = \App\Models\OurWorkDetail::whereSlug($slug)->get();
    return count($result);
}

function blogSlugKontrol($slug)

{

    $result = \App\Models\Blog::whereSlug($slug)->get();

    return count($result);

}

function sayfaSlugKontrol($slug)

{

    $result = \App\Models\PageDetail::whereSlug($slug)->get();

    return count($result);

}

function gallerySlugKontrol($slug)

{

    $result = \App\Models\ImageGalleryCategory::whereSlug($slug)->get();

    return count($result);

}

function videoGallerySlugKontrol($slug)

{

    $result = \App\Models\VideoGalleryCategoriesDetail::whereSlug($slug)->get();

    return count($result);

}

function photoGallerySlugKontrol($slug)

{

    $result = \App\Models\PhotoGalleryDetail::whereSlug($slug)->get();

    return count($result);

}

function blogViewArtir($blog_id)

{

    \App\Models\BlogDetail::where('blog_id', $blog_id)->update(['views' => DB::raw('views + 1')]);

}

function haberKategoriAdiGetir($category_id)
{

    $result = \App\Models\Category::where('category_id', $category_id)->firstOrFail();

    return $result->category_name;

}

function galeriGorseli($gallery_id)

{

    if ($result = \App\Models\ImageGallery::where('gallery_id', $gallery_id)->orderBy('rank')->first()) {

        return $result->image_path;

    } else {

        return 'http://via.placeholder.com/262x170';

    }

}

function rolesArray($model, $type)

{

    $modelData = \App\Models\MyModel::where('model', $model)->first();

    $roles = [];

    if ($modelData) {

        $rolelist = \App\Models\Permission::select('role_id')->where('model_id', $modelData->model_id)->where($type, 1)->groupBy('role_id')->get();

        if ($rolelist) {

            foreach ($rolelist as $role) {

                $roles[] = $role->role->name;

            }

        }

    }

    return $roles;

}

function create_captcha()

{

    session()->forget('captcha');

    sleep(1);

    $code = Str::random(6);

    session(['captcha' => $code]);

    return session('captcha');

}

function articleRate($article_id, $stars = false)

{

    $ratings = \App\Models\Rating::where('article_id', $article_id);

    $total_rate = $ratings->sum('rating');

    $count_rate = $ratings->count();

    if ($count_rate == 0) {

        $rate = 0;

    } else {

        $rate = number_format($total_rate / $count_rate, 1);

    }

    if ($stars) {

        return rateStars($rate);

    } else {

        return $rate;

    }

}

function articleRateCount($article_id) {
    return \App\Models\Rating::where('article_id', $article_id)->count();
}

function pageRate($page_id, $stars = false)

{

    $ratings = \App\Models\Rating::where('page_id', $page_id);

    $total_rate = $ratings->sum('rating');

    $count_rate = $ratings->count();

    if ($count_rate == 0) {

        $rate = 0;

    } else {

        $rate = number_format($total_rate / $count_rate, 1);

    }

    if ($stars) {

        return rateStars($rate);

    } else {

        return $rate;

    }

}

function blogRate($blog_id, $stars = false)

{

    $comments = \App\Models\Comment::where('blog_id', $blog_id)->where('status', 1)->where('upcomment_id', null)->get();

    $total_rate = $comments->sum('user_rate');

    $count_rate = $comments->count();

    if ($count_rate == 0) {

        $rate = 0;

    } else {

        $rate = number_format(($total_rate / $count_rate), 1);

    }

    if ($stars) {

        return rateStars($rate);

    } else {

        return $rate;

    }

}

function blogRateCount($blog_id)
{
    return \App\Models\Rating::where('blog_id', $blog_id)->count();
}

function videoRate($video_id, $stars = false)

{

    $ratings = \App\Models\Rating::where('video_id', $video_id);

    $total_rate = $ratings->sum('rating');

    $count_rate = $ratings->count();

    if ($count_rate == 0) {

        $rate = 0;

    } else {

        $rate = number_format($total_rate / $count_rate, 1);

    }

    if ($stars) {

        return rateStars($rate);

    } else {

        return $rate;

    }

}

function blogRateStats($blog_id, $language_id, $user_rate, $value = false)
{
    $comments = \App\Models\Comment::where('blog_id', $blog_id)->where('language_id', $language_id)->where('status', 1)->where('upcomment_id', null)->get()->count();
    $rate_count = \App\Models\Comment::where('article_id', $blog_id)->where('language_id', $language_id)->where('status', 1)->where('upcomment_id', null)->where('user_rate', $user_rate)->get()->count();
    if ($value) {
        return $rate_count;
    } else {
        if ($comments == 0) {
            return 0;
        } else {
            return round(($rate_count / $comments) * 100);
        }
    }
}

function articleRateStats($article_id, $user_rate, $value = false)

{

    $comments = \App\Models\Comment::where('article_id', $article_id)->where('status', 1)->where('language_id', session('lang'))->where('upcomment_id', null)->get()->count();

    $rate_count = \App\Models\Comment::where('article_id', $article_id)->where('status', 1)->where('language_id', session('lang'))->where('upcomment_id', null)->where('user_rate', $user_rate)->get()->count();

    if ($value) {

        return $rate_count;

    } else {

        if ($comments == 0) {

            return 0;

        } else {

            return round(($rate_count / $comments) * 100);

        }

    }

}

function rateStars($rate)

{

    $htm = '';

    for ($i = 1; $i <= 5; $i++) {

        if ($rate >= $i) {

            $htm .= '<i class="fas fa-star"></i>';

        } else if ($rate > $i - 1 && $rate < $i) {

            $htm .= '<i class="fas fa-star-half grayed"></i>';

        } else {

            $htm .= '<i class="fas fa-star text-muted"></i>';

        }

    }

    return $htm;

}

function articleCommentCount($article_id, $langid)

{

    return \App\Models\Comment::where('article_id', $article_id)->where('status', 1)->where('upcomment_id', null)->where('language_id', $langid)->count();

}

function BlogCommentCount($blog_id)

{

    return \App\Models\Comment::where('blog_id', $blog_id)->where('status', 1)->where('upcomment_id', null)->count();

}

function articleShortCodes($body)
{

    $outputs = [];
    preg_match_all('/\[video-id=(.*?)\]/', $body, $outputs);
    if (!empty($outputs[1])) {
        foreach ($outputs[1] as $key => $output) {
            $temp = explode(',', $output);
            $video = App\Models\VideoGalleriesDetail::where('video_id', $temp[0])->first();
            if ($video) {
                if ($temp[1] == 1) {
                    $video_data = '<iframe width="100%" style="min-height:250px;" src="' . $video->video_path . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
                } else {
                    $video_data = '<iframe width="20%"   src="' . $video->video_path . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';

                }
                $body = str_replace($outputs[0][$key], $video_data, $body);
            }
        }
    }

    return $body;

}

function commentStatuses($comment_id){

    $comment = \App\Models\Comment::selectRaw('user_like, user_dislike')->where('comment_id', $comment_id)->first();

    return $comment;

}

// hooks system
function hook($name, $callback = null, $value = null, $priority = 10)
{
    static $events = [];

    if ($callback !== null) {
        if ($callback) {
            $events[$name][$callback] = $priority;
        } else {
            unset($events[$name]);
        }
    } elseif (isset($events[$name])) {
        arsort($events[$name]);
        foreach ($events[$name] as $callback => $priority) {
            $value = call_user_func($callback, $value);
        }
        return $value;
    }
}

function add_action($name, $callback, $priority = 10)
{

    return hook($name, $callback, null, $priority);
}

function do_action($name, $value = null)
{
    return hook($name, null, $value);
}

function remove_action($name)
{
    hook($name, false);
}