<?php

namespace App\Exceptions;

use Exception;
use Http\Discovery\Exception\NotFoundException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        if ($exception instanceof NotFoundHttpException)
        {
            /*if($handler_hooks = do_action('backend.handler.NotFoundHttpException',$request)){
                return $handler_hooks;
            }*/

          return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);

        }

        if ($exception instanceof ModelNotFoundException)
        {
            if($handler_hooks = do_action('backend.handler.ModelNotFoundException',$request)){
                return $handler_hooks;
            }

        }
        if ($exception instanceof RelationNotFoundException)
        {
            $message = 'Aradığınız İlişki Bulunamadı';
            return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);
        }

        if ($exception instanceof RouteNotFoundException)
        {
            $message = 'Aradığınız Rota Bulunamadı';
            return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);

        }

        if ($exception instanceof ClassNotFoundException)

        {

            $message = 'Aradığınız Controller Bulunamadı';

            return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);

        }

        if ($exception instanceof MethodNotAllowedHttpException)

        {

            $message = 'Bu Urlye Bu Metod ile Ulaşamazsınız';

            return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);

        }

        /*if($exception instanceof CredentialsException)

        {

            return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.custom', compact('exception', 'message'), 500);

        }*/

        if ( ! config('app.debug') && ! $this->isHttpException($exception)) {

            return response('Küçük bir sorun ile karşılaşıldı en kısa sürede düzeltilecektir');/*view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);*/

        }
        return parent::render($request, $exception);
    }
}
