@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ route('adtrpanel.seo.redirects.new') }}"> <button type="button" class="btn btn-success"><i class="fa fa-plus"></i> {{ trans('admin.add_new') }}</button></a>
            </div>
        </div>
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Yönlendirilmiş URL Listesi</h1>

        <div style="margin-bottom:20px;background-color: #eeeeee;padding-top:10px;padding-left:15px;padding-right:15px;padding-bottom:15px;border-radius: 3px;border:1px solid #b6b6b6;"
             class="col-md-12">
            <span style="line-height: 35px;font-size: 14px;margin-bottom: 10px;font-weight: bold;">Filitreler :</span>
            <form action="post" id="table-filter" onchange="redirectFilter()">
                <div class="form-group">
                    <div class="form-group">
                        <input type="text" name="aranan" id="aranan" class="form-control" placeholder="Aradığınız URL Giriniz" value="{{old('aranan')}}" onkeyup="redirectFilter()" />
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="order_status">&nbsp;Durumu :&nbsp;</label>
                        <select id="order_status" onchange="redirectFilter()" class="form-control" name="redirect_status">
                            <option @if(old('category_status')) selected @endif value="all">Hepsi</option>
                            <option @if(old('category_status')) selected @endif value="1">Aktif</option>
                            <option @if(old('category_status')) selected @endif value="0">Pasif</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="order_status">&nbsp;Yönlendirme Tipi :&nbsp;</label>
                        <select id="order_status" onchange="redirectFilter()" class="form-control" name="redirect_type">
                            <option @if(old('category_status')) selected @endif value="all">Hepsi</option>
                            <option @if(old('category_status')) selected @endif value="301">301</option>
                            <option @if(old('category_status')) selected @endif value="302">302</option>
                            <option @if(old('category_status')) selected @endif value="307">307</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <div class="text-right  ">
                            <button type="button" style="margin-top: 25px;margin-right: 15px;" onclick="startExport();" class="btn btn-success btn-sm">Yönlendirmeleri Excele Aktar</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!--Ürünler-->
        <div class="table-responsive">
            <form method="post" action="{{route('adtrpanel.seo.redirects.multiple')}}" id="multiAction">
                {{csrf_field()}}
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th style="width: 3%;" class="text-center">
                            <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                <input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes" id="checkAll">
                                <span></span>
                            </label>
                        </th>
                        <th style="width: 12%;"> Eski URL</th>
                        <th style="width: 30%;"> Yeni URL</th>
                        <th style="width: 30%;"> Yönlendirme Türü</th>
                        <th style="width: 10%;"> Durumu</th>
                        <th style="width: 15%;"> İşlemler</th>
                    </tr>
                    </thead>
                    <tbody id="urllist">
                    @if (count($redirects) > 0 )
                        @foreach($redirects as $redirect)
                            <tr>
                                <td class="text-center">
                                    <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                        <input type="checkbox" name="multiple_id[]" value="{{ $redirect->redirect_id }}"
                                               class="group-checkable´orders_selector" data-set="#sample_1 .checkboxes">

                                        <span></span>
                                    </label>
                                </td>
                                <td>{{$redirect->source_url}}</td>
                                <td>{{$redirect->target_url}}</td>
                                <td>{{$redirect->type}}</td>
                                <td>
                                    @if ($redirect->status)
                                        <span class="badge badge-success">Aktif</span>
                                    @else
                                        <span class="badge badge-danger">Pasif</span>
                                    @endif
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm" title="Sil"
                                            onclick="confirmDelete({{$redirect->redirect_id}});">
                                        <i class="fa fa-times"></i>
                                    </button>
                                    <a href="{{ route('adtrpanel.seo.redirects.edit', $redirect->redirect_id) }}">
                                        <button type="button" class="btn btn-success btn-sm" title="Düzenle">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                    @if ($redirect->status)
                                        <a href="{{ route('adtrpanel.seo.redirects.deactivated', $redirect->redirect_id) }}">
                                            <button type="button" class="btn btn-warning btn-sm" title="Pasif Et">
                                                <i class="fas fa-lock"></i>
                                            </button>
                                        </a>
                                    @else
                                        <a href="{{ route('adtrpanel.seo.redirects.activated', $redirect->redirect_id) }}">
                                            <button type="button" class="btn btn-dark btn-sm" title="Aktif Et">
                                                <i class="fas fa-lock-open"></i>
                                            </button>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="6">
                                {{ $redirects->appends(['aranan' => old('aranan')])->links() }}
                            </td>
                        </tr>
                    @else
                        <tr class="odd gradeX">
                            <td colspan="6">Hiçbir url bulunamadı</td>
                        </tr>
                    @endif
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="5" style="text-align: right;">Seçilileri &nbsp;</td>
                        <td>
                            <select name="action" id="multiFormAction" onchange="formSubmit();"
                                    class="form-control">
                                <option value="" selected="selected">Seçiniz</option>
                                <option value="redirectDelete">Sil</option>
                                <option value="redirectActivate">Aktif Et</option>
                                <option value="redirectDeactivate">Pasif Et</option>
                            </select>
                        </td>
                    </tr>
                    </tfoot>
                </table>
            </form>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="seoredirect"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
    <script>
        function formSubmit() {
            var val = $('#multiFormAction option:selected').val();
            if (val == 'redirectDelete') {
                swal({
                    title: 'Emin misiniz?',
                    text: "Seçmiş Olduğunuz Tüm Yönlendirmeler Silinecek!",
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Evet Silinsin!',
                    cancelButtonText: 'Hayır Silme!'
                }).then((result) => {
                    if (result.value) {
                        $('#multiAction').submit();
                    }
                });
            } else {
                $('#multiAction').submit();
            }
        }
    </script>
    <script type="text/javascript">
        function redirectFilter() {
            var aranan = $("input[name='aranan']").val();
            var category_status = $("input[name='category_status']").val();
            if (aranan != '' || category_status != '') {
                var veriler = $('#table-filter').serialize();
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.redirectsAra') }}",
                    data: veriler,
                    dataType: "text",
                    cache: false,
                    success: function (sonuc) {
                        $('#urllist').html(sonuc);
                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            }
        }
        function confirmDelete(id) {
            swal({
                title: 'Emin misiniz',
                text: "Yönlendirme Sistemden Geri Dönüşsüz Olarak Silinecektir",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'Hayır Silme'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('adtrpanel.seo.redirects.delete') }}",
                        data: 'redirect_id=' + id,
                        dataType: "text",
                        cache: false,
                        success: function (sonuc) {
                            location.reload();
                        },
                        error: function (xhr, status, error) {
                            alert(xhr.responseText);
                        }
                    });
                } else {
                    return false;
                }
            })
        }
    </script>
    <script type="text/javascript">
        function startExport() {
            var data = $('#table-filter').serialize();
            var url = "{{url('adtrpanel/seo/yonlendirmeler/?')}}"+data;
            window.open(url);
        }
    </script>
@endsection