@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($redirect)) {{ route('adtrpanel.seo.redirects.save', $redirect->redirect_id) }} @else {{ route('adtrpanel.seo.redirects.save') }} @endif">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="source_url" class="col-sm-2 col-form-label">Eski URL <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="source_url" required  id="source_url" placeholder="Eski URL" @if(isset($redirect)) value="{{ $redirect->source_url }}" @endif />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="target_url" class="col-sm-2 col-form-label">Yeni URL <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="target_url" required  id="target_url" placeholder="Yeni URL" @if(isset($redirect)) value="{{ $redirect->target_url }}" @endif />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="type" class="col-sm-2 col-form-label">Yönlendirme Tipi</label>
                        <div class="col-sm-6">
                            <select id="type" class="form-control" name="type">
                                <option value=""> -- Seçiniz -- </option>
                                <option value="301" @if(isset($redirect) && $redirect->type == 301) selected="selected" @endif>301</option>
                                <option value="302" @if(isset($redirect) && $redirect->type == 302) selected="selected" @endif>302</option>
                                <option value="307" @if(isset($redirect) && $redirect->type == 307) selected="selected" @endif>307</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="status" class="col-sm-2 col-form-label">Durum</label>
                        <div class="col-sm-6">
                            <select id="status" class="form-control" name="status">
                                <option value="0" @if(isset($redirect) && $redirect->status == 0) selected="selected" @endif>Pasif</option>
                                <option value="1"@if(isset($redirect) && $redirect->status == 1) selected="selected" @endif>Aktif</option>
                            </select>
                        </div>
                    </div>
                    <!--Genel Bilgi Bittiker-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="seoredirect"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
@endsection