@if (count($redirects) > 0 )
    @foreach($redirects as $redirect)
        <tr>
            <td class="text-center">
                <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                    <input type="checkbox" name="multiple_id[]" class="group-checkable" data-set="#sample_1 .checkboxes" id="checkAll">
                    <span></span>
                </label>
            </td>
            <td>{{$redirect->source_url}}</td>
            <td>{{$redirect->target_url}}</td>
            <td>{{$redirect->type}}</td>
            <td>
                @if ($redirect->status)
                    <span class="badge badge-success">Aktif</span>
                @else
                    <span class="badge badge-danger">Pasif</span>
                @endif
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" title="Sil"
                        onclick="confirmDelete({{$redirect->redirect_id}});">
                    <i class="fa fa-times"></i>
                </button>
                <a href="{{ route('adtrpanel.seo.redirects.edit', $redirect->redirect_id) }}">
                    <button class="btn btn-success btn-sm" title="Düzenle">
                        <i class="fa fa-edit"></i>
                    </button>
                </a>
                @if ($redirect->status)
                    <a href="{{ route('adtrpanel.seo.redirects.deactivated', $redirect->redirect_id) }}">
                        <button class="btn btn-warning btn-sm" title="Pasif Et">
                            <i class="fas fa-lock"></i>
                        </button>
                    </a>
                @else
                    <a href="{{ route('adtrpanel.seo.redirects.activated', $redirect->redirect_id) }}">
                        <button class="btn btn-dark btn-sm" title="Aktif Et">
                            <i class="fas fa-lock-open"></i>
                        </button>
                    </a>
                @endif
            </td>
        </tr>
    @endforeach
    <tr>
        <td colspan="6" style="text-align: right;">Seçilileri &nbsp;</td>
        <td>
            <select name="islem" onchange="this.form.submit()" class="form-control">
                <option value="0" selected="selected">Seçiniz</option>
                <option value="sil">Sil</option>
            </select>
        </td>
    </tr>
    <tr>
        <td colspan="6">
            {{ $redirects->appends(['aranan' => old('aranan')])->links() }}
        </td>
    </tr>
@else
    <tr class="odd gradeX">
        <td colspan="6">Hiçbir url bulunamadı</td>
    </tr>
@endif