<?php

namespace Modules\SEO\SubModules\UrlRedirect\Providers;

use Modules\SEO\SubModules\UrlRedirect\Entities\UrlRedirect;
use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class UrlRedirectServiceProvider extends ServiceProvider
{

    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {

        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->hooks();

    }

    public function hooks(){
        add_action('adtrpanel.menu.seo', "Modules\SEO\SubModules\UrlRedirect\Providers\UrlRedirectServiceProvider::solMenu");
        add_action('backend.handler.NotFoundHttpException', "Modules\SEO\SubModules\UrlRedirect\Providers\UrlRedirectServiceProvider::NotFoundHttpException");
        add_action('backend.handler.ModelNotFoundException', "Modules\SEO\SubModules\UrlRedirect\Providers\UrlRedirectServiceProvider::ModelNotFoundException");

    }
    static public function solMenu($menu){

        $menu[] = view('urlredirect::blades.admin_solmenu')->render();
        return $menu;
    }
    static public function NotFoundHttpException($request){

        $adtrModules = Module::getByStatus(1);
        if (in_array("UrlRedirect", $adtrModules)) {
            $urlString = $request->fullUrl();
            $urlString = str_replace(['http://', 'https://', 'www'], '', $urlString);
            $url = UrlRedirect::where('source_url', 'like', '%' . $urlString . '%')->where('status', 1)->first();
            if($url)
            {
                return Redirect::to($url->target_url, $url->type);
            } else {
                $message = 'Aradığınız Sayfa Bulunamadı';
                return response()->view('adtrTheme::errors.404', compact('exception', 'message'), 404);
            }
        } else {
            return Redirect::to('/', 301);
        }
    }
    static public function ModelNotFoundException($request){

        $adtrModules = Module::getByStatus(1);
        if (in_array("UrlRedirect", $adtrModules)) {
            $urlString = $request->fullUrl();
            $urlString = str_replace(['http://', 'https://', 'www'], '', $urlString);
            $url = UrlRedirect::where('source_url', 'like', '%' . $urlString . '%')->where('status', 1)->first();
            if($url)
            {
                return Redirect::to($url->target_url, $url->type);
            } else {
                return Redirect::to('/', 301);
                /*$message = 'Aradığınız Model Bulunamadı';
                return response()->view('themes.'.Config('site_settings.themes_dir').'.errors.404', compact('exception', 'message'), 404);*/
            }
        } else {
            return Redirect::to('/', 301);
        }
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('urlredirect.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__.'/../Config/config.php', 'urlredirect'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/urlredirect');

        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ],'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/urlredirect';
        }, \Config::get('view.paths')), [$sourcePath]), 'urlredirect');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/urlredirect');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'urlredirect');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'urlredirect');
        }
    }

    /**
     * Register an additional directory of factories.
     * 
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
