<?php

namespace Modules\SEO\SubModules\UrlRedirect\Http\Controllers;

use Modules\SEO\SubModules\UrlRedirect\Entities\UrlRedirect;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

class UrlRedirectController extends Controller
{
    protected $controller;

    public function __construct()
    {
        $this->controller = new \App\Http\Controllers\Controller();
    }


    public function redirects()
    {
        $this->controller->authControl('SEO');
        $redirects = UrlRedirect::paginate(30);
        return view('urlredirect::redirects', compact('redirects'));
    }

    public function redirectForm($id = null)
    {

        if($id != null)
        {
            $this->controller->authControl('SEO','update');
            $redirect = UrlRedirect::where('redirect_id', $id)->first();
        } else {
            $this->controller->authControl('SEO','create');
        }
        return view('urlredirect::redirectform', compact('redirect'));
    }

    public function redirectSave($id = null)
    {
        if($id != null){
            $this->controller->authControl('SEO','update');
        } else {
            $this->controller->authControl('SEO','create');
        }

        $data = request()->only('source_url', 'target_url', 'type', 'status');
        if($id != null)
        {
            $redirect = UrlRedirect::where('redirect_id', $id)->update($data);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Yönlendirmesi Başarıyla Güncellendi'];
        } else {
            $redirect = UrlRedirect::create($data);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Yönlendirmesi Başarıyla Eklendi'];
        }
        return redirect()->route('adtrpanel.seo.redirects')->with($ndata);
    }

    public function redirectDelete()
    {
        $this->controller->authControl('SEO','delete');
        $redirect_id = request('redirect_id');
        UrlRedirect::find($redirect_id)->delete();
        $ndata = ['message_variable' => 'success', 'message' => 'URL Yönlendirmesi Başarıyla Silindi'];
        return redirect()->route('adtrpanel.seo.redirects')->with($ndata);
    }

    public function redirectActivatede($id = null) {

        if ($id != null) {
            $this->controller->authControl('SEO', 'update');
            $redirect = UrlRedirect::find($id)->update(['status' => 1]);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Yönlendirmesi Aktif Edildi'];
        }else {
            $this->controller->authControl('SEO','create');
            $ndata = ['message_variable' => 'warning', 'message' => 'URL Yönlendirmesi Pasif Edilemedi'];
        }
        return redirect()->back()->with($ndata);

    }

    public function redirectDeactivated($id = null) {

        if ($id != null) {
            $this->controller->authControl('SEO', 'update');
            $redirect = UrlRedirect::find($id)->update(['status' => 0]);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Yönlendirmesi Pasif Edildi'];
        }else {
            $this->controller->authControl('SEO','create');
            $ndata = ['message_variable' => 'warning', 'message' => 'URL Yönlendirmesi Pasif Edilemedi'];
        }
        return redirect()->back()->with($ndata);

    }

    public function redirectExport()
    {
        $redirects = UrlRedirect::select();
        if (request()->filled('aranan') || request()->filled('redirect_status') || request()->filled('redirect_type')) {
            $aranan = request('aranan');
            $status = request('redirect_status');
            $type = request('redirect_type');
            $redirects = UrlRedirect::select();

            if ($aranan) {
                $redirects = $redirects->where('source_url', 'like', '%' . $aranan . '%')
                    ->orwhere('target_url', 'like', '%' . $aranan . '%');
            }
            if (isset($status) && $status != "all") {
                $redirects = $redirects->where('status', $status);
            }
            if (isset($type) && $type != "all") {
                $redirects = $redirects->where('type', $type);
            }
            $redirects = $redirects->orderBy('redirect_id')->get();
        } else {
            $redirects = UrlRedirect::select()->get();
        }
        $redirect_array = [];
        foreach($redirects as $redirect)
        {
            $redirect_array[] = [
                'Yönlendirme ID' => $redirect->redirect_id,
                'Kaynak URL' => $redirect->source_url,
                'Hedef URL' => $redirect->target_url,
                'Yönlendirme Tipi' => $redirect->type,
                'Durumu' => $redirect->status ? 'Aktif' : 'Pasif'
            ];
        }

        \Excel::create('URL Yönlendirmeleri', function($excel) use($redirect_array) {
            $excel->sheet('Sipariş Genel Bilgileri', function($sheet) use($redirect_array) {
                $sheet->fromArray($redirect_array);
                $sheet->setHeight(1, 50);
                $sheet->setAutoSize(true);
                $sheet->freezeFirstRowAndColumn();
                $sheet->row(1, function($row) {
                    // call cell manipulation methods
                    $row->setBackground('#eaeaea');
                });
            });
        })->download('xls');
    }

    public function redirectsAra()
    {
        request()->flash();
        $redirects = UrlRedirect::select();
        if (request()->filled('aranan') || request()->filled('redirect_status') || request()->filled('redirect_type')) {
            $aranan = request('aranan');
            $status = request('redirect_status');
            $type = request('redirect_type');
            $redirects = UrlRedirect::select();

            if ($aranan) {
                $redirects = $redirects->where('source_url', 'like', '%' . $aranan . '%')
                    ->orwhere('target_url', 'like', '%' . $aranan . '%');
            }
            if (isset($status) && $status != "all") {
                $redirects = $redirects->where('status', $status);
            }
            if (isset($type) && $type != "all") {
                $redirects = $redirects->where('type', $type);
            }
            $redirects = $redirects->orderByDesc('created_at')
                ->paginate(15);
        } else {
            $redirects = UrlRedirect::select()->paginate(15);
        }
        $data = view('urlredirect::redirectara', compact('redirects', 'aranan'))->render();
        request()->flash();
        return $data;
    }
}
