<?php

namespace Modules\SEO\SubModules\UrlRedirect\Http\Controllers;

use Modules\SEO\SubModules\UrlRedirect\Entities\UrlRedirect;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

class MultipleActionController extends Controller
{
    public function multipleAction()
    {
        $ids = request()->has('multiple_id') ? request('multiple_id') : null;
        $action = request()->has('action') ? request('action') : null;
        $ndata = ['message_variable' => 'danger', 'message' => 'Yetkiniz Yetersiz.'];
        if ($action != null) {
            if ($ids != null) {
                switch ($action) {
                    case 'redirectDelete':
                        if (authControl('SEO', 'delete')) {
                            return self::redirectMultipleDelete($ids);
                        } else {
                            return redirect()->back()->with($ndata);
                        }
                        break;
                    case 'redirectActivate':
                        if (authControl('SEO', 'update')) {
                            return self::redirectMultipleActivate($ids);
                        } else {
                            return redirect()->back()->with($ndata);
                        }
                        break;
                    case 'redirectDeactivate':
                        if (authControl('SEO', 'update')) {
                            return self::redirectMultipleDeactivate($ids);
                        } else {
                            return redirect()->back()->with($ndata);
                        }
                        break;
                }
            } else {
                return redirect()->back()->with(['message_variable' => 'warning', 'message' => 'İşlem Yapmak İçin Herhangi Bir Eleman Seçmediniz']);
            }
        } else {
            return redirect()->back()->with(['message_variable' => 'warning', 'message' => 'Herhangi Bir İşlem Seçmediniz']);
        }
    }

    public function  redirectMultipleDelete($ids){
        UrlRedirect::whereIn('redirect_id', $ids)->delete();
        return redirect()->route('adtrpanel.seo.redirects')->with(['message_variable' => 'success', 'message' => 'Seçtiğiniz Yönlendirmeler Silinmiştir.']);
    }
    public function  redirectMultipleActivate($ids){
        UrlRedirect::whereIn('redirect_id', $ids)->update(['status' => "1"]);
        return redirect()->route('adtrpanel.seo.redirects')->with(['message_variable' => 'success', 'message' => 'Seçtiğiniz  Yönlendirmeler Aktif Edilmiştir.']);
    }
    public function  redirectMultipleDeactivate($ids){
        UrlRedirect::whereIn('redirect_id', $ids)->update(['status' => "0"]);
        return redirect()->route('adtrpanel.seo.redirects')->with(['message_variable' => 'success', 'message' => 'Seçtiğiniz  Yönlendirmeler Pasif Edilmiştir.']);
    }
}
