<?php

namespace Modules\SEO\SubModules\UrlRedirect\Http\Controllers;

use App\Models\MenuDetail;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */

    public $message = [];
    private $module;
    private $ndata ;

    public function __construct()
    {
        $this->module = Module::find('UrlRedirect');
    }

    public function activate() {

        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';

        if (Schema::hasTable('redirects')) {
            $this->message[] = 'Tablo Zaten Mevcut. Migration Çalıştırılamadı';
        }else {
            Artisan::call('module:migrate', ['module' => 'UrlRedirect', '--force' => true]);
            $this->message[] = 'Migration Çalıştırıldı';
            Artisan::call('module:seed', ['module' => 'UrlRedirect', '--force' => true]);
            $this->message[] = 'Seeder Çalıştırıldı';
        }
        $this->ndata = ['message_variable' => 'success', 'message' => 'Url Redirect aktif edildi.'];
        return redirect()->back()->with($this->ndata);
    }

    public function remove() {
        Schema::dropIfExists('redirects');
        DB::table('migrations')->where('migration', 'like', '%redirects_table%')->delete();
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function deactivate()
    {
        $type = request()->get('type');
        $this->ndata = ['message_variable' => 'success', 'message' => 'Url Redirect pasif edildi.'];
        if (!empty($type) && $type == 1) {
            Schema::dropIfExists('redirects');
            DB::table('migrations')->where('migration', 'like', '%_create_redirects%')->delete();
            $this->ndata = ['message_variable' => 'success', 'message' => 'Url Redirect pasif edildi. Tablolar Silindi.'];
        }
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return redirect()->back()->with($this->ndata);
    }




}
