@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <form method="post" action="@if(isset($sitemap_url)) {{ route('adtrpanel.seo.sitemaps.save', $sitemap_url->sitemap_url_id) }} @else {{ route('adtrpanel.seo.sitemaps.save') }} @endif">
            {{ csrf_field() }}
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="{{ URL::previous() }}"> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                        </button></a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="general_info">
                    <!--Genel Bilgiler-->
                    <div class="form-group row">
                        <label for="url" class="col-sm-2 col-form-label">İşlem Görecek URL <i class="fas fa-question-circle info-circle" data-html="true" data-toggle="tooltip" data-placement="right" title="İşlem görmesini istediğiniz url yi tam olarak yani başında domain ile birlikte yazınız. Sitenizde SSL kullanılıyorsa 'http' olarak eklediğiniz urller işlem görmeyecektir."></i>
                        </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="url" required  id="url" placeholder="İşlem Görecek URL" @if(isset($sitemap_url)) value="{{$sitemap_url->url}}" @endif />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="type" class="col-sm-2 col-form-label">URL Tipi</label>
                        <div class="col-sm-6">
                            <select id="type" class="form-control" name="type">
                                <option value=""> -- Seçiniz -- </option>
                                <option value="product" @if(isset($sitemap_url) && $sitemap_url->type == 'product') selected="selected" @endif>Ürün URL si</option>
                                <option value="category" @if(isset($sitemap_url) && $sitemap_url->type == 'category') selected="selected" @endif>Kategori URL si</option>
                                <option value="brand" @if(isset($sitemap_url) && $sitemap_url->type == 'brand') selected="selected" @endif>Marka URL si</option>
                                <option value="page" @if(isset($sitemap_url) && $sitemap_url->type == 'page') selected="selected" @endif>Statik Sayfa URL si</option>
                                @if(isset($sitemap_url))
                                    @php $url = $sitemap_url @endphp
                                @else
                                    @php $url = [] @endphp
                                @endif
                                @if($new_types = do_action('adtrpanel.sitemap.add.type', $url))
                                    @foreach($new_types as $new_type)
                                        {!! $new_type !!}
                                    @endforeach
                                @endif
                                <option value="other" @if(isset($sitemap_url) && $sitemap_url->type == 'other') selected="selected" @endif>Diğer Sayfa URL si</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="changefreq" class="col-sm-2 col-form-label">URL Güncelleme Sıklığı<br /><small>(Changefreq)</small></label>
                        <div class="col-sm-6">
                            <select id="changefreq" class="form-control" name="changefreq">
                                <option value=""> -- Seçiniz -- </option>
                                <option value="always" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'always') selected="selected" @endif>Always</option>
                                <option value="hourly" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'hourly') selected="selected" @endif>Hourly</option>
                                <option value="daily" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'daily') selected="selected" @endif>Daily</option>
                                <option value="weekly" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'weekly') selected="selected" @endif>Weekly</option>
                                <option value="monthly" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'monthly') selected="selected" @endif>Monthly</option>
                                <option value="yearly" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'yearly') selected="selected" @endif>Yearly</option>
                                <option value="never" @if(isset($sitemap_url) && $sitemap_url->changefreq == 'never') selected="selected" @endif>Never</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="priority" class="col-sm-2 col-form-label">URL Priority<br /><small>(Öncelik)</small>
                        </label>
                        <div class="col-sm-6">
                            <select id="priority" class="form-control" name="priority">
                                <option value=""> -- Seçiniz -- </option>
                                <option value="1.0" @if(isset($sitemap_url) && $sitemap_url->priority == '1.0') selected="selected" @endif>1.0</option>
                                <option value="0.9" @if(isset($sitemap_url) && $sitemap_url->priority == '0.9') selected="selected" @endif>0.9</option>
                                <option value="0.8" @if(isset($sitemap_url) && $sitemap_url->priority == '0.8') selected="selected" @endif>0.8</option>
                                <option value="0.7" @if(isset($sitemap_url) && $sitemap_url->priority == '0.7') selected="selected" @endif>0.7</option>
                                <option value="0.6" @if(isset($sitemap_url) && $sitemap_url->priority == '0.6') selected="selected" @endif>0.6</option>
                                <option value="0.5" @if(isset($sitemap_url) && $sitemap_url->priority == '0.5') selected="selected" @endif>0.5</option>
                                <option value="0.4" @if(isset($sitemap_url) && $sitemap_url->priority == '0.4') selected="selected" @endif>0.4</option>
                                <option value="0.3" @if(isset($sitemap_url) && $sitemap_url->priority == '0.3') selected="selected" @endif>0.3</option>
                                <option value="0.2" @if(isset($sitemap_url) && $sitemap_url->priority == '0.2') selected="selected" @endif>0.2</option>
                                <option value="0.1" @if(isset($sitemap_url) && $sitemap_url->priority == '0.1') selected="selected" @endif>0.1</option>
                                <option value="0.0" @if(isset($sitemap_url) && $sitemap_url->priority == '0.0') selected="selected" @endif>0.0</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="view" class="col-sm-2 col-form-label">URL Durumu</label>
                        <div class="col-sm-6">
                            <select id="view" class="form-control" name="view">
                                <option value="1"@if(isset($sitemap_url) && $sitemap_url->view == 1) selected="selected" @endif>URL Sitemap de Gözüksün</option>
                                <option value="0" @if(isset($sitemap_url) && $sitemap_url->view == 0) selected="selected" @endif>URL Sitemap de Gözükmesin</option>
                            </select>
                        </div>
                    </div>
                    <!--Genel Bilgi Bittiker-->
                </div>
            </div>
        </form>
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="sitemap"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
@endsection