@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <section class="page-content">
            <form method="post" action="{{route('adtrpanel.seo.sitemaps.settings.save')}}">
                {{ csrf_field() }}
                <h1>Ayarlar</h1>
                <div class="text-right">
                    <div class="actions btn-set">
                        <a href=""> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                            </button></a>
                        <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                        <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                    </div>
                </div>
                <hr>
                <!--Masaüstü Sekme Linkleri-->
                <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                    <ul class="nav nav-tabs product-tabs-select">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                        </li>
                    </ul>
                </div>
                <!--Masaüstü Sekme Linkleri Bitti-->

                <!--Mobil Sekme Linkleri-->
                <div class="d-lg-none d-sm-block tabs-mobile">
                    <select title="Sekme seçiniz" class="mobile-select">
                        <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                    </select>
                </div>
                <!--Mobil Sekme Linkleri Bitti-->
                <!-- Tab panes -->
                <div class="tab-content">
                    <div class="tab-pane active" id="general_info">
                        <!--Genel Bilgiler-->
                        <div class="form-group row">
                            <label for="default_changefreq" class="col-sm-4 col-form-label">Kullanılacak Default Güncelleme Sıklığı Değeri<br /><small>(Changefreq)</small></label>
                            <div class="col-sm-6">
                                <select id="default_changefreq" class="form-control" name="default_changefreq">
                                    <option value=""> -- Seçiniz -- </option>
                                    <option value="always" @if(config('module_settings.sitemap.default_changefreq', 'daily') == 'always') selected="selected" @endif>Always</option>
                                    <option value="hourly" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'hourly') selected="selected" @endif>Hourly</option>
                                    <option value="daily" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'daily') selected="selected" @endif>Daily</option>
                                    <option value="weekly" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'weekly') selected="selected" @endif>Weekly</option>
                                    <option value="monthly" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'monthly') selected="selected" @endif>Monthly</option>
                                    <option value="yearly" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'yearly') selected="selected" @endif>Yearly</option>
                                    <option value="never" @if(config('module_settings.sitemap.default_changefreq', 'daily')  == 'never') selected="selected" @endif>Never</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="default_priority" class="col-sm-4 col-form-label">Kullanılacak Default Öncelik<br /><small>(Priority)</small>
                            </label>
                            <div class="col-sm-6">
                                <select id="default_priority" class="form-control" name="default_priority">
                                    <option value=""> -- Seçiniz -- </option>
                                    <option value="1.0" @if(config('module_settings.sitemap.default_priority', '0.5') == '1.0') selected="selected" @endif>1.0</option>
                                    <option value="0.9" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.9') selected="selected" @endif>0.9</option>
                                    <option value="0.8" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.8') selected="selected" @endif>0.8</option>
                                    <option value="0.7" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.7') selected="selected" @endif>0.7</option>
                                    <option value="0.6" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.6') selected="selected" @endif>0.6</option>
                                    <option value="0.5" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.5') selected="selected" @endif>0.5</option>
                                    <option value="0.4" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.4') selected="selected" @endif>0.4</option>
                                    <option value="0.3" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.3') selected="selected" @endif>0.3</option>
                                    <option value="0.2" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.2') selected="selected" @endif>0.2</option>
                                    <option value="0.1" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.1') selected="selected" @endif>0.1</option>
                                    <option value="0.0" @if(config('module_settings.sitemap.default_priority', '0.5') == '0.0') selected="selected" @endif>0.0</option>
                                </select>
                            </div>
                        </div>
                        <!--Genel Bilgi Bittiker-->
                    </div>
                </div>
            </form>
        </section>
@endsection