@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section id="app" class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">Sitemap Yönetimi</h1>
        <div class="text-right">
            <div class="actions btn-set">
                <a href="{{ route('sitemaps.regenerate') }}" target="_blank">
                    <button type="button" name="yeniden-olustur"  class="btn btn-warning"><i class="fa fa-refresh"></i>
                        Sitemapları Yeniden Oluştur
                    </button>
                </a>
                <a href="{{ route('adtrpanel.seo.sitemaps.create') }}">
                    <button type="button" name="olustur" value="1" class="btn btn-success"><i class="fa fa-plus"></i>
                        Yeni URL Ekle
                    </button>
                </a>
            </div>
        </div>
        <form action="" method="post" autocomplete="off">
            <!-- MODÜLLER -->
            <div style="margin-bottom:20px;background-color: #eeeeee;padding-top:10px;padding-left:15px;padding-right:15px;padding-bottom:15px;border-radius: 3px;border:1px solid #b6b6b6;"
                 class="col-md-12">
                <span style="line-height: 35px;font-size: 14px;margin-bottom: 10px;font-weight: bold;">Filtreler :</span>
                <form action="post" id="table-filter" onchange="return false;">
                    <div class="form-group">
                        <div class="form-group">
                            <input type="text" name="aranan" id="aranan" class="form-control"
                                   placeholder="URL giriniz." value="{{ old('aranan')}}"/>
                        </div>
                    </div>
                </form>
            </div>
            <small>
                <p><strong>Not - 1 :</strong> Bu sayfada gösterilen URL ler sitemapte gözükmesini istemediğiniz yada bazı ayarlarının farklı gözükmesini isteiğiniz URL lerdir. Bu listede olmayan tüm URL ler standart veriler ile sitemapde listelenecektir</p>
                <p><strong>Not - 2 :</strong> Ana sitemap URL niz <code>{{config('app.url')}}/sitemaps/sitemap.xml</code> dir</p>
            </small>
            <div class="table-responsive">

                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>

                            <th style="width:45%;" class="text-center">URL</th>
                            <th class="text-center" style="width: 10%;">Tipi</th>
                            <th class="text-center" style="width: 15%;">Güncellenme Sıklığı<br />(Changefreq)</th>
                            <th class="text-center" style="width: 10%;">Önceliği<br />(Priority)</th>
                            <th class="text-center" style="width: 10%;">Durumu</th>
                            <th class="text-center" style="width: 10%;">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody id="urlList">
                        @include('sitemap::adtrpanel.urllist')
                    </tbody>
                </table>
            </div>
        </form>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="#sitemap"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
    <script>
        $(document).ready(function () {
            $('#aranan').keyup(function () {
                var q = $('#aranan').val();
                $.ajax({
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('adtrpanel.seo.sitemaps.search') }}",
                    data: "q=" + q,
                    dataType: "json",
                    cache: false,
                    success: function (result) {
                        console.info(result.data);
                        $('#urlList').html(result.data);
                    },
                    error: function (xhr, status, error) {
                        alert(xhr.responseText);
                    }
                });
            });
        });
    </script>
    <script>
        function confirmDelete(id) {
            swal({
                title: 'Emin misiniz',
                text: "URL yi silmek istediğininize emin misiniz?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'Hayır Silme'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('adtrpanel.seo.sitemaps.delete') }}",
                        data: 'sitemap_url_id=' + id,
                        dataType: "text",
                        cache: false,
                        success: function (sonuc) {
                            location.reload();
                        },
                        error: function (xhr, status, error) {
                            alert(xhr.responseText);
                        }
                    });
                } else {
                    return false;
                }
            })
        }
    </script>
@endsection