<?php

namespace Modules\SEO\SubModules\SiteMap\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class SiteMapServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->hooks();
    }

    public function hooks()
    {
        add_action('adtrpanel.menu.seo', "Modules\SEO\SubModules\SiteMap\Http\Controllers\HooksController::solMenu");
        add_action('adtrpanel.sitemap.add.type', "Modules\SEO\SubModules\SiteMap\Http\Controllers\HooksController::addSitemapType");
        add_action('adtrpanel.sitemap.list.type', "Modules\SEO\SubModules\SiteMap\Http\Controllers\HooksController::addSitemapListType");
        add_action('adtrpanel.seo.sitemap.generator.after', "Modules\SEO\SubModules\SiteMap\Http\Controllers\HooksController::blogSitemapGenerator");
    }

    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('sitemap.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__.'/../Config/config.php', 'sitemap'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/sitemap');

        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ],'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/sitemap';
        }, \Config::get('view.paths')), [$sourcePath]), 'sitemap');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/sitemap');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'sitemap');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'sitemap');
        }
    }

    /**
     * Register an additional directory of factories.
     * 
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
