<?php

namespace Modules\SEO\SubModules\SiteMap\Http\Controllers;

use App\Models\Brand;
use App\Models\Category;
use App\Models\Page;
use App\Models\Product;
use App\Models\ProductImages;
use Carbon\Carbon;
use Modules\SEO\SubModules\SiteMap\Entities\SiteMapUrl;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Spatie\ArrayToXml\ArrayToXml;
use Illuminate\Support\Facades\File;

class SiteMapController extends Controller
{
    public function index()
    {
        $sitemap_urls = SiteMapUrl::all();
        return view('sitemap::adtrpanel.index', compact('sitemap_urls'));
    }

    public function create($id = null)
    {
        if($id != null)
        {
            $sitemap_url = SiteMapUrl::find($id);
        }
        return view('sitemap::adtrpanel.urlform', compact('sitemap_url'));
    }

    public function save($id = null)
    {
        $data = request()->only('url', 'type', 'changefreq', 'priority', 'view');
        if($id != null)
        {
            SiteMapUrl::find($id)->update($data);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Başarıyla Güncellendi'];
        } else {
            SiteMapUrl::create($data);
            $ndata = ['message_variable' => 'success', 'message' => 'URL Başarıyla Eklendi'];
        }
        return redirect()->route('adtrpanel.seo.sitemaps')->with($ndata);
    }

    public function delete()
    {
        SiteMapUrl::find(request('sitemap_url_id'))->delete();
        $ndata = ['message_variable' => 'success', 'message' => 'URL Başarıyla Silindi'];
        return redirect()->route('adtrpanel.seo.sitemaps')->with($ndata);
    }

    public function search()
    {
        $aranan = request('q');
        $sitemap_urls = SiteMapUrl::where('url', 'like', '%'.$aranan.'%')->get();
        $url = view('sitemap::adtrpanel.urllist', compact('sitemap_urls'))->render();
        return response()->json(['data' => $url]);
    }

    public function sitemapGenerator()
    {
        $old_urls = config('app.url') . '/sitemaps/sitemap.xml';
        if(file_exists(public_path('/sitemaps/sitemap.xml')))
        {
            $ch = curl_init($old_urls);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $xml = simplexml_load_string(curl_exec($ch), 'SimpleXMLElement', LIBXML_COMPACT | LIBXML_PARSEHUGE);
            curl_close($ch);
            if(count($xml->children()) > 0)
            {
                foreach ($xml->children() as $child)
                {
                    $sitemap_link = str_replace(config('app.url').'/', '', $child->loc);
                    if(file_exists(public_path($sitemap_link)))
                    {
                        unlink(public_path($sitemap_link));
                    }
                }
            }
            $sitemap_link = str_replace(config('app.url').'/', '', $old_urls);
            unlink(public_path($sitemap_link));
        }
        $sitemaps = [];
        $sitemaps = $this->productSitemapGenerator($sitemaps);
        $sitemaps = $this->categorySitemapGenerator($sitemaps);
        $sitemaps = $this->pageSitemapGenerator($sitemaps);
        $sitemaps = $this->brandSitemapGenerator($sitemaps);
        $sitemaps = $this->imageSitemapGenerator($sitemaps);
        if($new_sitemaps = do_action('adtrpanel.seo.sitemap.generator.after', $sitemaps))
        {
            $sitemaps = $new_sitemaps;
        }
        $map_list = [];
        $map_attribute = [
            'rootElementName' => 'urlset',
            '_attributes' => [
                'xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9'
            ]
        ];
        foreach ($sitemaps as $sitemap_name => $sitemap)
        {
            if(strstr($sitemap_name, "image"))
            {
                $map_attribute['_attributes']['xmlns:image'] = 'http://www.google.com/schemas/sitemap-image/1.1';
            }
            if(count($sitemap) > 1)
            {
                $i = 1;
                foreach ($sitemap as $map)
                {
                    if($i == 1)
                    {
                        $filename = $sitemap_name.'.xml';
                        $file = public_path('sitemaps/'.$filename);
                        $result = ArrayToXml::convert($map, $map_attribute,true, 'UTF-8');
                        File::put($file, $result);
                    } else {
                        $filename = $sitemap_name.$i.'.xml';
                        $file = public_path('sitemaps/'.$filename);
                        $result = ArrayToXml::convert($map, $map_attribute,true,'UTF-8');
                        File::put($file, $result);
                    }
                    $map_list['sitemap'][]['loc'] = config('app.url') . '/sitemaps/'.$filename;
                    $i++;
                }
            } else {
                $filename = $sitemap_name.'.xml';
                $file = public_path('sitemaps/'.$filename);
                $result = ArrayToXml::convert($sitemap[0], $map_attribute,true,'UTF-8');
                File::put($file, $result);
                $map_list['sitemap'][]['loc'] = config('app.url') . '/sitemaps/'.$filename;
            }
        }
        unset($map_attribute);
        $map_attribute = [
            'rootElementName' => 'sitemapindex',
            '_attributes' => [
                'xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9'
            ]
        ];
        $result = ArrayToXml::convert($map_list, $map_attribute,true,'UTF-8');
        File::put(public_path('sitemaps/sitemap.xml'), $result);
        return response('Tüm Sitemap ler başarıyla yeniden oluşturuldu.');
    }

    private function productSitemapGenerator($sitemaps)
    {
        $product_sitemap = [];
        $products = Product::where('product_status', 1)->get();
        if(count($products) > 0)
        {
            $product_count = 1;
            foreach ($products as $product)
            {
                if($product_count == 40000 || $product_count == count($products))
                {
                    $product_count = 1;
                    $sitemaps['product-sitemap'][] = $product_sitemap;
                    unset($product_sitemap);
                    $product_sitemap = [];
                }
                $product_url = config('app.url').'/urun/'.$product->slug;
                if($new_product_url = do_action('modules.sitemap.product_url', $product))
                {
                    $product_url = $new_product_url;
                }
                $sitemap_url = SiteMapUrl::where('type', 'product')->where('url', $product_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $product_sitemap['url'][] = [
                            'loc' => $sitemap_url['url'],
                            'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                            'changefreq' => $sitemap_url['changefreq'],
                            'priority' => $sitemap_url['priority']
                        ];
                    }
                } else {
                    $product_sitemap['url'][] = [
                        'loc' => $product_url,
                        'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                        'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                        'priority' => config('module_settings.sitemap.default_priority', '0.5')
                    ];
                }
                $product_count++;
            }
        }
        return $sitemaps;
    }

    private function categorySitemapGenerator($sitemaps)
    {
        $category_sitemap = [];
        $categories = Category::where('status', 1)->get();
        if(count($categories) > 0)
        {
            $category_count = 1;
            foreach ($categories as $category)
            {
                if($category_count == 40000 || $category_count == count($categories))
                {
                    $category_count = 1;
                    $sitemaps['category-sitemap'][] = $category_sitemap;
                    unset($category_sitemap);
                    $category_sitemap = [];
                }
                $category_url = config('app.url').'/kategori/'.$category->slug;
                if($new_category_url = do_action('modules.sitemap.category_url', $category))
                {
                    $category_url = $new_category_url;
                }
                $sitemap_url = SiteMapUrl::where('type', 'category')->where('url', $category_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $category_sitemap[ 'url'][] = [
                            'loc' => $sitemap_url['url'],
                            'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                            'changefreq' => $sitemap_url['changefreq'],
                            'priority' => $sitemap_url['priority']
                        ];
                    }
                } else {
                    $category_sitemap['url'][] = [
                        'loc' => $category_url,
                        'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                        'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                        'priority' => config('module_settings.sitemap.default_priority', '0.5')
                    ];
                }
                $category_count++;
            }
        }
        return $sitemaps;
    }

    private function pageSitemapGenerator($sitemaps)
    {
        $page_sitemap = [];
        $url = config('app.url');
        $sitemap_url = SiteMapUrl::where('type', 'other')->where('url', $url)->first();
        if($sitemap_url)
        {
            if($sitemap_url->view == 1)
            {
                $page_sitemap['url'][] = [
                    'loc' => $sitemap_url['url'],
                    'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                    'changefreq' => $sitemap_url['changefreq'],
                    'priority' => $sitemap_url['priority']
                ];
            }
        } else {
            $page_sitemap['url'][] = [
                'loc' => config('app.url'),
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                'priority' => config('module_settings.sitemap.default_priority', '0.5')
            ];
        }
        $pages = Page::where('status', 1)->get();
        if(count($pages) > 0)
        {
            $page_count = 1;
            foreach ($pages as $page)
            {
                if($page_count == 40000 || $page_count == count($pages))
                {
                    $page_count = 1;
                    $sitemaps['page-sitemap'][] = $page_sitemap;
                    unset($page_sitemap);
                    $page_sitemap = [];
                }
                $page_url = config('app.url').'/sayfa/'.$page->slug;
                if($new_page_url = do_action('modules.sitemap.page_url', $page))
                {
                    $page_url = $new_page_url;
                }
                $sitemap_url = SiteMapUrl::where('type', 'page')->where('url', $page_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $page_sitemap['url'][] = [
                            'loc' => $sitemap_url['url'],
                            'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                            'changefreq' => $sitemap_url['changefreq'],
                            'priority' => $sitemap_url['priority']
                        ];
                    }
                } else {
                    $page_sitemap['url'][] = [
                        'loc' => $page_url,
                        'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                        'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                        'priority' => config('module_settings.sitemap.default_priority', '0.5')
                    ];
                }
                $page_count++;
            }
        }
        return $sitemaps;
    }

    private function brandSitemapGenerator($sitemaps)
    {
        $brand_sitemap = [];
        $url = config('app.url') . '/markalar';
        $sitemap_url = SiteMapUrl::where('type', 'brand')->where('url', $url)->first();
        if($sitemap_url)
        {
            if($sitemap_url->view == 1)
            {
                $brand_sitemap['url'][] = [
                    'loc' => $sitemap_url['url'],
                    'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                    'changefreq' => $sitemap_url['changefreq'],
                    'priority' => $sitemap_url['priority']
                ];
            }
        } else {
            $brand_sitemap['url'][] = [
                'loc' => $url,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                'priority' => config('module_settings.sitemap.default_priority', '0.5')
            ];
        }
        $brands = Brand::all();
        if(count($brands) > 0)
        {
            $brand_count = 1;
            foreach ($brands as $brand)
            {
                if($brand_count == 40000 || $brand_count == count($brands))
                {
                    $brand_count = 1;
                    $sitemaps['brand-sitemap'][] = $brand_sitemap;
                    unset($brand_sitemap);
                    $brand_sitemap = [];
                }
                $brand_url = config('app.url').'/markalar/'.$brand->slug;
                if($new_brand_url = do_action('modules.sitemap.brand_url', $brand))
                {
                    $brand_url = $new_brand_url;
                }
                $sitemap_url = SiteMapUrl::where('type', 'brand')->where('url', $brand_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $brand_sitemap['url'][] = [
                            'loc' => $sitemap_url['url'],
                            'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                            'changefreq' => $sitemap_url['changefreq'],
                            'priority' => $sitemap_url['priority']
                        ];
                    }
                } else {
                    $brand_sitemap['url'][] = [
                        'loc' => $brand_url,
                        'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                        'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                        'priority' => config('module_settings.sitemap.default_priority', '0.5')
                    ];
                }
                $brand_count++;
            }
        }
        return $sitemaps;
    }

    private function imageSitemapGenerator($sitemaps)
    {
        $image_sitemap = [];
        $images = ProductImages::groupBy('product_id')->get();
        if(count($images) > 0)
        {
            $image_count = 1;
            foreach ($images as $image)
            {
                if($image_count == 950 || $image_count == count($images))
                {
                    $image_count = 1;
                    $sitemaps['image-sitemap'][] = $image_sitemap;
                    unset($image_sitemap);
                    $image_sitemap = [];
                }
                $product_url = config('app.url').'/urun/'.$image->product->slug;
                if($new_product_url = do_action('modules.sitemap.product_url', $image->product))
                {
                    $product_url = $new_product_url;
                }
                $map_data = [
                    'loc' => $product_url
                ];
                $pimages = ProductImages::where('product_id', $image->product_id)->get();
                foreach ($pimages as $pimage)
                {
                    $image_url = config('app.url').$pimage->path;
                    if($new_image_url = do_action('modules.sitemap.image_url', $pimage))
                    {
                        $image_url = $new_image_url;
                    }
                    $sitemap_url = SiteMapUrl::where('type', 'image')->where('url', $image_url)->first();
                    if($sitemap_url)
                    {
                        if($sitemap_url->view == 1)
                        {
                            $map_data['image:image'][] = [
                                'image:loc' => $image_url,
                                'image:caption' => $image->product->product_name,
                                'image:title' => $image->product->product_name,
                            ];
                        }
                    } else {
                        $map_data['image:image'][] = [
                            'image:loc' => $image_url,
                            'image:caption' => $image->product->product_name,
                            'image:title' => $image->product->product_name,
                        ];
                    }
                }
                if($extra_images = do_action('adtrpanel.seo.sitemaps.images-sitemap-generator.add.before', ['image' => $image, 'map_data' => $map_data]))
                {
                    $map_data = $extra_images;
                }
                $image_sitemap['url'][] = $map_data;
                $image_count++;
            }
        }
        return $sitemaps;
    }
}