<?php

namespace Modules\SEO\SubModules\SiteMap\Http\Controllers;

use App\Models\ModuleSetting;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    public $message = [];
    private $module;

    public function __construct()
    {
        $this->module = Module::find('SiteMap');
    }

    public function activate()
    {
        if(Schema::hasTable('sitemap_urls'))
        {
            $this->message[] = 'Tablo Zaten Mevcut Migration Çalıştırılmadı';
        } else {
            Artisan::call('module:migrate', ['module' => 'SiteMap', '--force' => true]);
            $this->message[] = 'Migration Çalıştırıldı';
        }
        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';
        return $this->message;
    }

    public function deactivate()
    {
        $this->message[] = 'Databaseden Tablolar Silindi';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function remove() {
        Schema::dropIfExists('sitemap_urls');
        DB::table('migrations')->where('migration', 'like','%sitemap_urls%')->delete();
        DB::table('module_settings')->where('module_name', 'like','%'.$this->module->alias.'%')->delete();
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function settingsForm() {
        return view('sitemap::adtrpanel.settings_form');
    }

    public function saveSettings() {

        $validatedData = request()->validate([
            'default_changefreq' => 'required',
            'default_priority' => 'required'
        ]);

        $datas = request()->only('default_changefreq', 'default_priority');

        foreach ($datas as $key => $value) {
            $saveSettings = ModuleSetting::updateOrCreate(
                [
                    'module_name' => $this->module->alias,
                    'entry' => $key
                ],
                [
                    'value' => $value
                ]
            );
        }

        if ($saveSettings) {
            $this->message = ['message_variable' => 'success', 'message' => 'Ayarlar kaydedildi'];
        }else {
            $this->message = ['message_variable' => 'warning', 'message' => 'Ayarlar kaydedilemedi'];;
        }

        return redirect()->back()->with($this->message);

    }
}