<?php

namespace Modules\Seo\SubModules\SiteMap\Http\Controllers;

use App\Models\Options;
use App\Models\Product;
use App\Models\ProductImages;
use Carbon\Carbon;
use Modules\Blog\Entities\Blog;
use Modules\SEO\SubModules\SeoImages\Entities\SeoImage;
use Modules\SEO\SubModules\SeoImages\Entities\SeoImageSettings;
use Modules\SEO\SubModules\SiteMap\Entities\SiteMapUrl;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;

class HooksController extends Controller
{
    public static function solMenu($menu)
    {
        $menu[] = view('sitemap::blades.admin_solmenu')->render();
        return $menu;
    }

    public static function addSitemapType($url)
    {
        if($url != null)
        {
            $sitemap_url = $url;
        }
        $types[] = view('sitemap::blades.admin-add-sitemap-type', compact('sitemap_url'))->render();
        return $types;
    }

    public static function addSitemapListType($type)
    {
        if($type == 'blog')
        {
            $new_type = 'Blog Yazısı URL si';
        } else {
            $new_type = '';
        }
        return $new_type;
    }

    public static function blogSitemapGenerator($sitemaps)
    {
        $blog_sitemap = [];
        $url = config('app.url') . '/blog';
        $sitemap_url = SiteMapUrl::where('type', 'blog')->where('url', $url)->first();
        if($sitemap_url)
        {
            if($sitemap_url->view == 1)
            {
                $blog_sitemap['url'][] = [
                    'loc' => $sitemap_url['url'],
                    'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                    'changefreq' => $sitemap_url['changefreq'],
                    'priority' => $sitemap_url['priority']
                ];
            }
        } else {
            $blog_sitemap['url'][] = [
                'loc' => $url,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                'priority' => config('module_settings.sitemap.priority', '0.5')
            ];
        }
        $blogs = Blog::all();
        if(count($blogs) > 0)
        {
            $blog_count = 1;
            foreach ($blogs as $blog)
            {
                if($blog_count == 40000 || $blog_count == count($blogs))
                {
                    $blog_count = 1;
                    $sitemaps['blog-sitemap'][] = $blog_sitemap;
                    unset($blog_sitemap);
                    $blog_sitemap = [];
                }
                $blog_url = config('app.url').'/blog/'.$blog->slug;
                $sitemap_url = SiteMapUrl::where('type', 'blog')->where('url', $blog_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $blog_sitemap['url'][] = [
                            'loc' => $sitemap_url['url'],
                            'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                            'changefreq' => $sitemap_url['changefreq'],
                            'priority' => $sitemap_url['priority']
                        ];
                    }
                } else {
                    $blog_sitemap['url'][] = [
                        'loc' => $blog_url,
                        'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                        'changefreq' => config('module_settings.sitemap.default_changefreq', 'daily'),
                        'priority' => config('module_settings.sitemap.priority', '0.5')
                    ];
                }
                $blog_count++;
            }
        }
        return $sitemaps;
    }
}