<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSitemapUrlsTable extends Migration
{
    public function up()
    {
        Schema::create('sitemap_urls', function (Blueprint $table) {
            $table->increments('sitemap_url_id');
            $table->string('type', 255);
            $table->string('url', 255);
            $table->string('changefreq', 20)->nullable();
            $table->string('priority', 5)->nullable();
            $table->boolean('view')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('sitemap_urls');
    }
}
