@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    @include('adtrpanel.partials.errors')
    @include('adtrpanel.partials.alert')
    <section class="page-content">
        <form method="post" action="{{ route('adtrpanel.seo.seoimages.saveSettings') }}">
            {{ csrf_field() }}
            <h1>Ayarlar</h1>
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                    <button type="button" value="1" onclick="addNewSeoSettings()" class="btn btn-success"><i
                                class="fa fa-plus"></i>
                        Yeni Seçenek Ekle
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#seo_image">Seo Resim Ayarları</a>
                    </li>
                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#seo_image">Seo Resim Ayarları</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="seo_image">

                    <div class="table-responsive">

                        <table style="margin-bottom: 50px;" class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>

                                <th style="width: 20%;"> Benzersiz Tanımlayıcı Anahtar</th>
                                <th style="width: 20%;"> En(px)</th>
                                <th style="width: 20%;"> Boy(px)</th>
                                <th style="width: 20%;"> Maximum Boyut(kb)</th>
                                <th style="width: 20%;"> İşlemler</th>
                            </tr>
                            </thead>
                            <tbody id="seo_settings_list">
                            @if(count($seo_image_settings = \Modules\SEO\SubModules\SeoImages\Entities\SeoImageSettings::all()) > 0)
                                @php
                                    $i = 0;
                                @endphp
                                @foreach($seo_image_settings as $seo_image_setting)
                                    <tr class="seo-list">
                                        <td><input class="form-control" disabled placeholder="Bir Key Değeri Girin"
                                                   type="text" name="seo_settings[{{$i++}}]['key']"
                                                   value="{{ $seo_image_setting->key }}"></td>
                                        <td><input class="form-control" disabled placeholder="Genişlik Değeri"
                                                   type="number" name="seo_settings[{{$i++}}]['image_width']"
                                                   value="{{ $seo_image_setting->image_width }}"></td>
                                        <td><input class="form-control" disabled placeholder="Uzunluk Değeri"
                                                   type="number" name="seo_settings[{{$i++}}]['image_height']"
                                                   required="required" value="{{ $seo_image_setting->image_height }}">
                                        </td>
                                        <td><input class="form-control" disabled type="number"
                                                   placeholder="Maksimum resim boyutu girin"
                                                   name="seo_settings[{{$i++}}]['max_size']"
                                                   value="{{ $seo_image_setting->max_size }}" required="required"></td>
                                        <td>
                                            <button onclick="removeSeoSettings({{$seo_image_setting->seo_image_settings_id}})"
                                                    class="btn btn-danger" type="button"><i class=" fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr id="null_seo_settings" class="odd gradeX">
                                    <td  colspan="9">Hiçbir ürün bulunamadı</td>
                                </tr>
                            @endif


                            </tbody>

                        </table>

                    </div>


                </div>
            </div>
        </form>
    </section>
@endsection

@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="seomodulemanagement"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
    <script>
        function addNewSeoSettings() {

            var col = $('#seo_settings_list tr.seo-list').length;
            $('#null_seo_settings').remove();
            $('button').prop('disabled',true);
            $.ajax({
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('adtrpanel.seo.seoimages.settings_add_row') }}",
                data: 'col=' + col,
                dataType: "json",
                cache: false,
                success: function (response) {
                    $('button').prop('disabled',false);
                    if (response.result == "success") {
                        $('#seo_settings_list').append(response.html);
                    }

                },
                error: function (xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        }

        function removeSeoSettings(id) {
            swal({
                title: 'Emin misiniz',
                text: "Bu seçenekteki tüm seo resimleri kalıcı olarak silinecektir",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet Sil',
                cancelButtonText: 'Hayır Silme'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('adtrpanel.seo.seoimages.delete') }}",
                        data: 'seo_image_setting_id=' + id,
                        dataType: "json",
                        cache: false,
                        success: function (response) {
                            if (response.result == "success") {
                                const toast = swal.mixin({
                                    toast: true,
                                    position: 'top-end',
                                    showConfirmButton: false,
                                    timer: 3000
                                });

                                toast({
                                    type: 'success',
                                    title: response.message
                                })
                                location.reload();
                            }
                        },
                        error: function (xhr, status, error) {
                            alert(xhr.responseText);
                        }
                    });
                } else {
                    return false;
                }
            })
        }
    </script>
@endsection