@if(!empty($product_image))
    <tr id="seo-product-image-{{ $product_image->product_image_id }}">
        <td class="text-center">
            <img style="max-width: 80%" src="{{ $product_image->path }}">
        </td>
        <td>

                <table class="col-12">
                    <small>Resmi Yüklemeden Önce Tüm Koşulları Eksiksiz Sağladığına Emin Olun.</small>
                    <tbody>
                    @if($seo_image_settings)
                        @foreach($seo_image_settings as $image_setting)
                            @php
                                $seo_image = \Modules\SEO\SubModules\SeoImages\Entities\SeoImage::where('product_image_id', $product_image->product_image_id)->where('seo_image_settings_id', $image_setting->seo_image_settings_id)->first();
                            @endphp
                            <tr>
                                <td style="width: 20%" class="text-center">
                                    <small class="d-block"><strong>Koşullar</strong></small>
                                    <small class="d-block">Alan Tanımı : {{ $image_setting->key }}</small>
                                    <small class="d-block">En : {{ $image_setting->image_width }} px | Boy
                                        : {{ $image_setting->image_height }} px
                                    </small>
                                    <small class="d-block">Maksimum Dosya Boyutu : {{ $image_setting->max_size }}kb
                                    </small>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="file"
                                               name="seo_image_file[{{ $product_image->product_image_id }}][{{ $image_setting->key }}]"
                                               class="form-control">
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            @if(isset($seo_image) && $seo_image->auto_create == 0)
                                                <i title="Resim Yüklendi" class="fa fa-check-circle"></i>
                                            @elseif(isset($seo_image) && $seo_image->auto_create == 1)
                                                <i title="Resim Otomatik Oluşturuldu." class="fas fa-robot"></i>
                                            @else
                                                <i title="resim bulunamadı." class="fa fa-exclamation-triangle"></i>
                                            @endif
                                        </span>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
        </td>
    </tr>



@endif