<?php

namespace Modules\SEO\SubModules\SeoImages\Providers;

use Illuminate\Database\Eloquent\Factory;
use Illuminate\Support\ServiceProvider;

class SeoImagesServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->hooks();
    }

    public function hooks()
    {
        add_action('adtrpanel.product.tabs', "Modules\SEO\SubModules\SeoImages\Http\Controllers\HooksController::adtrPanelProductPageTab");

        add_action('adtrpanel.productoption.image_save.after', "Modules\SEO\SubModules\SeoImages\Http\Controllers\HooksController::productFormSaveSeoImage");
        add_action('adtrpanel.product.javascript', "Modules\SEO\SubModules\SeoImages\Http\Controllers\HooksController::productFormJavaScript");
        add_action('adtrpanel.seo.sitemaps.images-sitemap-generator.add.before', "Modules\SEO\SubModules\SeoImages\Http\Controllers\HooksController::addImagesSitemapGenerator");
        add_action('frontend.getProductImages.return_before', "Modules\SEO\SubModules\SeoImages\Http\Controllers\HooksController::getProductImageUpdateHooks");
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__ . '/../Config/config.php' => config_path('seoimages.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__ . '/../Config/config.php', 'seoimages'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/seoimages');

        $sourcePath = __DIR__ . '/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ], 'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/seoimages';
        }, \Config::get('view.paths')), [$sourcePath]), 'seoimages');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/seoimages');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'seoimages');
        } else {
            $this->loadTranslationsFrom(__DIR__ . '/../Resources/lang', 'seoimages');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories()
    {
        if (!app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
