<?php

namespace Modules\SEO\SubModules\SeoImages\Http\Controllers;

use Modules\SEO\SubModules\SeoImages\Entities\SeoImageSettings;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */

    public $message = [];
    private $module;
    private $ndata;

    public function __construct()
    {
        $this->module = Module::find('SeoImages');
    }

    public function activate()
    {

        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';

        if (Schema::hasTable('seo_images_settings') && Schema::hasTable('seo_product_images')) {
            $this->message[] = 'Tablo Zaten Mevcut. Migration Çalıştırılamadı';
        } else {
            Artisan::call('module:migrate', ['module' => 'SeoImages', '--force' => true]);
            $this->message[] = 'Migration Çalıştırıldı';
            Artisan::call('module:seed', ['module' => 'SeoImages', '--force' => true]);
            $this->message[] = 'Seeder Çalıştırıldı';
        }
        $this->ndata = ['message_variable' => 'success', 'message' => 'Seo Image aktif edildi.'];
        return redirect()->back()->with($this->ndata);
    }

    public function remove()
    {
        Schema::dropIfExists('seo_product_images');
        Schema::dropIfExists('seo_images_settings');
        DB::table('migrations')->where('migration', 'like', '%_create_seo_images_settings%')->delete();
        DB::table('migrations')->where('migration', 'like', '%_create_seo_image_table%')->delete();
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function deactivate($type = null)
    {

        $this->ndata = ['message_variable' => 'success', 'message' => 'Seo Image pasif edildi.'];
        if (!empty($type) && $type == 1) {
            Schema::dropIfExists('seo_product_images');
            Schema::dropIfExists('seo_images_settings');
            DB::table('migrations')->where('migration', 'like', '%_create_seo_images_settings%')->delete();
            DB::table('migrations')->where('migration', 'like', '%_create_seo_image_table%')->delete();
            $this->ndata = ['message_variable' => 'success', 'message' => 'Url Redirect pasif edildi. Tablolar Silindi.'];
        }
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return redirect()->back()->with($this->ndata);
    }

    public function saveSettings()
    {
        $error = [];
        $success = [];
        if (request()->has('seo_settings')) {
            foreach (request('seo_settings') as $new_seo_image_setting) {
                $seo_settings = SeoImageSettings::where('key', $new_seo_image_setting['key'])->first();
                if (empty($seo_settings)) {
                    if (!empty($new_seo_image_setting['key'])) {
                        if (!empty($new_seo_image_setting['image_width'])) {
                            if (!empty($new_seo_image_setting['image_height'])) {
                                if (empty($new_seo_image_setting['max_size'])) {
                                    $new_seo_image_setting['max_size'] = 300;
                                }
                                $new_setting = SeoImageSettings::create($new_seo_image_setting);
                                if ($new_setting) {
                                    $success[] = [
                                        'message_variable' => 'success',
                                        'message' => 'Kayıt Eklendi.'
                                    ];
                                }
                            } else {
                                $error[] = "Boy Alanı Boş Bırakılamaz.";
                            }
                        } else {
                            $error[] = "En Alanı Boş Bırakılamaz.";
                        }
                    } else {
                        $error[] = "Key Alanı Boş Bırakılamaz.";
                    }
                } else {
                    $error[] = $new_seo_image_setting['key'] . " key değeri zaten kullanılmış.";
                }
            }
        }
        if (count($error) > 0) {
            return redirect()->back()->withErrors($error);
        } else {
            $ndata = ['message_variable' => 'success', 'message' => 'Ayarlarınız kaydedildi'];
            return redirect()->back()->with($ndata);
        }


    }


}
