<?php

namespace Modules\Seo\SubModules\SeoImages\Http\Controllers;

use App\Models\Options;
use App\Models\Product;
use App\Models\ProductImages;
use Modules\SEO\SubModules\SeoImages\Entities\SeoImage;
use Modules\SEO\SubModules\SeoImages\Entities\SeoImageSettings;
use Modules\SEO\SubModules\SiteMap\Entities\SiteMapUrl;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;

class HooksController extends Controller
{



    public static function adtrPanelProductPageTab($hook_data)
    {

        if (!empty($hook_data['product'])) {
            $product = $hook_data['product'];
            $seo_product_images = [];
            $product_images = ProductImages::where('product_id', $product->product_id)->get();

            if ($product_images) {
                $seo_product_images = SeoImage::whereIn('product_image_id', $product_images)->get();

            }
            $seo_image_settings = SeoImageSettings::all();

            $title = "<li class=\"nav-item\"><a class=\"nav-link\" data-toggle=\"pill\" href=\"#seoimage\">Seo Resimleri</a></li>";
            $mobil_title = " <option data-toggle=\"pill\" value=\"#seoimage\">Seo Resimleri</option>";
            $content = view('seoimages::adtrpanel.product.tab_content', compact('product_images', 'seo_image_settings'))->render();
            $hook_data['return_data'][] = [
                'status' => 1,
                'title' => $title,
                'mobil_title' => $mobil_title,
                'content' => $content
            ];
        }

        return $hook_data;
    }

    public static function productFormSaveSeoImage($data)
    {
        $error_message = [];
        if (request()->has('seo_image_file')) {

            if (!empty(request('seo_image_file')) && count(request('seo_image_file'))) {
                foreach (request('seo_image_file') as $product_image_id => $seo_image_file) {

                    foreach (SeoImageSettings::all() as $seo_image_settings) {
                        if (isset($seo_image_file[$seo_image_settings->key])) {
                            $file = $seo_image_file[$seo_image_settings->key];

                            $fileArray = array('image' => $file);
                            $rules = array(
                                'image' => 'mimes:jpeg,jpg,png,gif|required|max:' . $seo_image_settings->max_size . '|dimensions:width=' . $seo_image_settings->image_width . ',height=' . $seo_image_settings->image_height . '' // max 10000kb
                            );
                            $fieldNames = array(
                                'image' => 'Seo Resim Alanında ' . $product_image_id . ' nolu resim ' . $seo_image_settings->key . ' resmi'
                            );
                            $validator = Validator::make($fileArray, $rules);
                            $validator->setAttributeNames($fieldNames);
                            if ($validator->fails()) {
                                //gelen resim koşullara uymuyorsa

                                $image_check = SeoImage::where('product_image_id', $product_image_id)->where('seo_image_settings_id', $seo_image_settings->seo_image_settings_id)->first();
                                if (empty($image_check)) {
                                    // seo image tablosunda o seçeneğin resmi yok ise
                                    $product_image = ProductImages::where('product_image_id', $product_image_id)->first();
                                    if ($product_image) {
                                        if (!empty($product_image->option_id)) {
                                            $opt = Options::where('option_id', $product_image->option_id)->first();
                                            $option_name = $opt->option_name . "-" . $seo_image_settings->key;
                                        } else {
                                            $option_name = $seo_image_settings->key;
                                        }
                                        //ürünün resmini alıyoruz
                                        $product = Product::where('product_id', $data['product_id'])->first();
                                        $new_image_dir = '/uploads/products/seoimage/' . str_slug($product->slug) . '-' . $option_name . '-' . $seo_image_settings->image_width . 'x' . $seo_image_settings->image_height . "." . $file->getClientOriginalExtension();
                                        $i = 1;
                                        for (; file_exists(public_path($new_image_dir));) {

                                            $new_image_dir = '/uploads/products/seoimage/' . str_slug($product->slug) . '-' . $i . '-' . $option_name . '-' . $seo_image_settings->image_width . 'x' . $seo_image_settings->image_height . "." . $file->getClientOriginalExtension();
                                            $i++;
                                        }
                                        //resimi kaydet
                                        $new_image = Image::make(public_path($product_image->path))->fit($seo_image_settings->image_width, $seo_image_settings->image_height)->save(public_path($new_image_dir));

                                        $file_image = Image::make(public_path($new_image_dir));
                                        $image_size = $file_image->filesize();
                                        SeoImage::updateOrCreate(
                                            [
                                                'product_image_id' => $product_image_id,
                                                'seo_image_settings_id' => $seo_image_settings->seo_image_settings_id
                                            ],
                                            [
                                                'path' => $new_image_dir,
                                                'auto_create' => 1,
                                                'size' => $image_size

                                            ]
                                        );

                                    }
                                    $error_message[] = $validator->errors()->getMessages();
                                } else {
                                    $error_message[] = $validator->errors()->getMessages();
                                }

                            } else {
                                //save file
                                $product_image = ProductImages::where('product_image_id', $product_image_id)->first();
                                $product = Product::where('product_id', $data['product_id'])->first();
                                if (!empty($product_image->option_id)) {
                                    $opt = Options::where('option_id', $product_image->option_id)->first();
                                    $option_name = $opt->option_name . "-" . $seo_image_settings->key;
                                } else {
                                    $option_name = $seo_image_settings->key;
                                }

                                $new_image_dir = '/uploads/products/seoimage/' . str_slug($product->slug) . '-' . $option_name . '-' . $seo_image_settings->image_width . 'x' . $seo_image_settings->image_height . '.' . $file->getClientOriginalExtension();
                                Image::make($file)->save(public_path($new_image_dir));
                                $file_image = Image::make(public_path($new_image_dir));
                                $image_size = $file_image->filesize();
                                SeoImage::updateOrCreate(
                                    [
                                        'product_image_id' => $product_image_id,
                                        'seo_image_settings_id' => $seo_image_settings->seo_image_settings_id
                                    ],
                                    [
                                        'path' => $new_image_dir,
                                        'auto_create' => 0,
                                        'size' => $image_size

                                    ]
                                );
                            };
                        }
                    }
                }
            }
        }
        Session::flash('message', 'This is a message!');
        Session::flash('message_variable', 'danger');

        //Ekstra resim kontrolü Yeni Ürün Eklenirken yüklenen resmin direk olarak otomatik boyutlandırma.
        $product_images = ProductImages::where('product_id', $data['product_id'])->get();
        if ($product_images) {
            foreach ($product_images as $product_image) {
                $product_image_id = $product_image->product_image_id;
                foreach (SeoImageSettings::all() as $seo_image_settings) {
                    $seo_image = SeoImage::where('product_image_id', $product_image_id)->where('seo_image_settings_id', $seo_image_settings->seo_image_settings_id)->first();
                    if (empty($seo_image)) {
                        $extension = strtolower(pathinfo(public_path($product_image->path), PATHINFO_EXTENSION));
                        if ($product_image) {
                            if (!empty($product_image->option_id)) {
                                $opt = Options::where('option_id', $product_image->option_id)->first();
                                $option_name = $opt->option_name . "-" . $seo_image_settings->key;
                            } else {
                                $option_name = $seo_image_settings->key;
                            }
                            //ürünün resmini alıyoruz
                            $product = Product::where('product_id', $data['product_id'])->first();
                            $new_image_dir = '/uploads/products/seoimage/' . str_slug($product->slug) . '-' . $option_name . '-' . $seo_image_settings->image_width . 'x' . $seo_image_settings->image_height . "." . $extension;
                            //ve o boyutlarda yeni resim oluşturuyoruz
                            $i = 1;
                            for (; file_exists(public_path($new_image_dir));) {

                                $new_image_dir = '/uploads/products/seoimage/' . str_slug($product->slug) . '-' . $i . '-' . $option_name . '-' . $seo_image_settings->image_width . 'x' . $seo_image_settings->image_height . "." . $extension;
                                $i++;
                            }
                            //eger otomatik oluşturulan resim adı sunucuda yok ise
                            $new_image = Image::make(public_path($product_image->path))->resize($seo_image_settings->image_width, $seo_image_settings->image_height)->save(public_path($new_image_dir));


                            $file_image = Image::make(public_path($new_image_dir));
                            $image_size = $file_image->filesize();
                            SeoImage::updateOrCreate(
                                [
                                    'product_image_id' => $product_image_id,
                                    'seo_image_settings_id' => $seo_image_settings->seo_image_settings_id
                                ],
                                [
                                    'path' => $new_image_dir,
                                    'auto_create' => 1,
                                    'size' => $image_size
                                ]
                            );
                        }
                    }
                }
            }

        }
        return $data;
    }

    public static function productFormJavaScript($data)
    {

        if (!empty($data['product'])) {
            $javascript = view('seoimages::adtrpanel.product.javascript')->render();
            $data['return_data'][] = [
                'status' => 1,
                'data' => $javascript,
            ];
        }
        return $data;
    }

    public static function getProductImageUpdateHooks($data)
    {
        if ($data['values'] != 'main') {
            if (!empty($data['product_images']['product_id'])) {
                //tek gelen resmi diziye çevirme hata vermemesi için
                $val = $data['product_images'];
                unset($data['product_images']);
                $data['product_images'][0] = $val;
            }
            if (count($data['product_images']) > 0) {
                //birden fazla değere alabiliyor ise
                $seo_product_images = [];
                $image_data = [];
                if (is_array($data['values'])) {
                    $width = $data['values']['width'];
                    $height = $data['values']['height'];
                    if (!empty($width) && !empty($height)) {
                        $seo_image_settings = SeoImageSettings::where('image_width', $width)->where('image_height')->first();
                        if ($seo_image_settings) {
                            $seo_image_setting_id = $seo_image_settings->seo_image_settings_id;
                        }
                    }
                } else {
                    $seo_image_settings = SeoImageSettings::where('key', $data['values'])->first();
                    if ($seo_image_settings) {
                        $seo_image_setting_id = $seo_image_settings->seo_image_settings_id;
                    }
                }

                if (!empty($seo_image_setting_id)) {
                    foreach ($data['product_images'] as $product_image) {

                        $seo_image = SeoImage::where('product_image_id', $product_image['product_image_id'])->where('seo_image_settings_id', $seo_image_setting_id)->first();
                        if ($seo_image) {
                            //seo tablosunda aranıyor
                            if ($data['limit'] == 1){
                                $image_data = [
                                    'product_image_id' => $product_image['product_image_id'],
                                    'product_id' => $product_image['product_id'],
                                    'option_id' => $product_image['option_id'],
                                    'path' => assetImageFolder($seo_image->path),
                                    'image_width' => $seo_image_settings->image_width,
                                    'image_height' => $seo_image_settings->image_height,
                                    'type' => $seo_image_settings->key,
                                    'alt_and_title' => $product_image['alt_and_title'],
                                    'featured' => $product_image['featured']
                                ];
                            } else {
                                $image_data[] = [
                                    'product_image_id' => $product_image['product_image_id'],
                                    'product_id' => $product_image['product_id'],
                                    'option_id' => $product_image['option_id'],
                                    'path' => assetImageFolder($seo_image->path),
                                    'image_width' => $seo_image_settings->image_width,
                                    'image_height' => $seo_image_settings->image_height,
                                    'type' => $seo_image_settings->key,
                                    'alt_and_title' => $product_image['alt_and_title'],
                                    'featured' => $product_image['featured']
                                ];
                            }
                        }
                    }
                    if (count($image_data) > 0) {
                        $seo_product_images = $image_data;
                    }
                }
            }

        } else {
            if (!empty($data['product_images']->product_id)) {
                //tek gelen resmi diziye çevirme hata vermemesi için
                $val = $data['product_images'];
                unset($data['product_images']);
                $data['product_images'][0] = $val;
            }
            //ana resmi direk std class ile aynı düzende geri gönderme
            foreach ($data['product_images'] as $product_image) {
                if ($data['limit'] == 1){
                    $image_data= [
                        'product_image_id' => $product_image['product_image_id'],
                        'product_id' => $product_image['product_id'],
                        'option_id' => $product_image['option_id'],
                        'path' => assetImageFolder($product_image->path),
                        'image_width' => $product_image['image_width'],
                        'image_height' => $product_image['image_height'],
                        'type' => 'main',
                        'alt_and_title' => $product_image['alt_and_title'],
                        'featured' => $product_image['featured']
                    ];
                } else {
                    $image_data[] = [
                        'product_image_id' => $product_image['product_image_id'],
                        'product_id' => $product_image['product_id'],
                        'option_id' => $product_image['option_id'],
                        'path' => assetImageFolder($product_image->path),
                        'image_width' => $product_image['image_width'],
                        'image_height' => $product_image['image_height'],
                        'type' => 'main',
                        'alt_and_title' => $product_image['alt_and_title'],
                        'featured' => $product_image['featured']
                    ];
                }

            }
            if (count($image_data) > 0) {
                $seo_product_images = $image_data;
            }
        }
        if (isset($seo_product_images) && count($image_data) > 0) {
            $data['product_images'] = $seo_product_images;
        }

        return $data;
    }

    public static function addImagesSitemapGenerator($datas)
    {
        $pimage = $datas['image'];
        $map_data = $datas['map_data'];
        $images = SeoImage::where('product_image_id', $pimage->product_image_id)->get();
        if(count($images) > 0)
        {
            foreach ($images as $image)
            {
                $image_url = config('app.url').$image->path;
                $sitemap_url = SiteMapUrl::where('type', 'image')->where('url', $image_url)->first();
                if($sitemap_url)
                {
                    if($sitemap_url->view == 1)
                    {
                        $map_data['image:image'][] = [
                            'image:loc' => $image_url,
                            'image:caption' => $pimage->product->product_name,
                            'image:title' => $pimage->product->product_name,
                        ];
                    }
                } else {
                    $map_data['image:image'][] = [
                        'image:loc' => $image_url,
                        'image:caption' => $pimage->product->product_name,
                        'image:title' => $pimage->product->product_name,
                    ];
                }
            }
        }
        return $map_data;
    }

}
