<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSeoImageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seo_product_images', function (Blueprint $table) {
            $table->increments('seo_product_image_id');
            $table->unsignedInteger('product_image_id');
            $table->unsignedInteger('seo_image_settings_id');
            $table->integer('size')->nullable();
            $table->string('path'); 
            $table->boolean('auto_create')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('product_image_id')->references('product_image_id')->on('product_images')->onDelete('cascade');
            $table->foreign('seo_image_settings_id')->references('seo_image_settings_id')->on('seo_images_settings')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('seo_product_images');
    }
}
