<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSeoImagesSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seo_images_settings', function (Blueprint $table) {
            $table->increments('seo_image_settings_id')->unsigned();;
            $table->string('key');
            $table->integer('image_width')->default(0);
            $table->integer('image_height')->default(0);
            $table->integer('max_size');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('seo_image_settings');
    }
}
