<?php

namespace Modules\SEO\SubModules\Robots\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

class RobotController extends Controller
{

    public function index()
    {

        if(file_exists(public_path('robots.txt'))) {

            $dosya = fopen(public_path('robots.txt'), 'r');
            $robots_txt = fread($dosya, filesize('robots.txt'));
            fclose($dosya);
            return view('robot::robots_txt_edit',compact('robots_txt'));

        } else {
            $ndata = [
                'message' => 'robots.txt dosyası bulunamadı. Bu Sayfa Aracılığı ile robots.txt oluşturabilirsiniz.'
            ];
            return view('robot::robots_txt_edit',compact('robots_txt'))->withErrors($ndata);
        }


    }

    public function save(){

        if (request()->has('robots')){

            $robots_txt = request('robots');
            $dosya = fopen(public_path('robots.txt'), 'w');
            fwrite($dosya, $robots_txt);
            fclose($dosya);
            $ndata = [
                'message_variable' => 'success',
                'message' => 'Başarılı Bir Şekilde Kaydedildi.'
            ];
            return redirect()->back()->with($ndata);
        }

    }

}
