<?php

namespace Modules\SEO\SubModules\Robots\Http\Controllers;

use App\Models\MenuDetail;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */

    public $message = [];
    private $module;
    private $ndata ;

    public function __construct()
    {
        $this->module = Module::find('Robots');
    }

    public function activate() {

        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';

        $this->ndata = ['message_variable' => 'success', 'message' => 'Robots Editor aktif edildi.'];
        return redirect()->back()->with($this->ndata);
    }

    public function remove() {

        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function deactivate()
    {
        $type = request()->get('type');
        $this->ndata = ['message_variable' => 'success', 'message' => 'Robots pasif edildi.'];
        if (!empty($type) && $type == 1) {
            $this->ndata = ['message_variable' => 'success', 'message' => 'Robots pasif edildi. Tablolar Silindi.'];
        }
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return redirect()->back()->with($this->ndata);
    }




}
