@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    @include('adtrpanel.partials.errors')
    @include('adtrpanel.partials.alert')
    <section class="page-content">
        <form method="post" action="{{ route('adtrpanel.seo.noindex.saveSettings') }}">
            {{ csrf_field() }}
            <h1>Ayarlar</h1>
            <div class="text-right">
                <div class="actions btn-set">
                    <a href="">
                        <button type="button" name="back" class="btn btn-secondary-outline"><i
                                    class="fa fa-angle-left"></i> Geri
                        </button>
                    </a>
                    <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                    <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i>
                        Kaydet
                    </button>
                </div>
            </div>
            <hr>
            <!--Masaüstü Sekme Linkleri-->
            <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                <ul class="nav nav-tabs product-tabs-select">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#general_settings">Genel Ayarlar</a>
                    </li>

                </ul>
            </div>
            <!--Masaüstü Sekme Linkleri Bitti-->

            <!--Mobil Sekme Linkleri-->
            <div class="d-lg-none d-sm-block tabs-mobile">
                <select title="Sekme seçiniz" class="mobile-select">
                    <option data-toggle="pill" value="#general_settings">Genel Ayarlar</option>
                </select>
            </div>
            <!--Mobil Sekme Linkleri Bitti-->
            <!-- Tab panes -->
            <div class="tab-content">
                <div class="tab-pane active" id="product_info">
                    <div class="form-group row">
                        <label for="brands_page_noindex" class="col-sm-3 col-form-label">Marka Listesi Sayfasına NoIndex Uygulansın mı ?
                            <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-9">
                            <div style="display: inline-grid;" class="material-switch pull-right">
                                <input id="brands_page_noindex" {{ !empty(config('module_settings.noindex.brands_page_noindex')) ? "checked" : '' }}   value="1"  name="brands_page_noindex"  type="checkbox"/>
                                <label for="brands_page_noindex" class="label-success"></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="search_page_noindex" class="col-sm-3 col-form-label">Arama Sonucu Sayfasına NoIndex Uygulansın mı ?
                            <span class="required-input">*</span>
                        </label>
                        <div class="col-sm-9">
                            <div style="display: inline-grid;" class="material-switch pull-right">
                                <input id="search_page_noindex" {{ !empty(config('module_settings.noindex.search_page_noindex')) ? "checked" : '' }}   value="1"  name="search_page_noindex"  type="checkbox"/>
                                <label for="search_page_noindex" class="label-success"></label>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </form>
    </section>
@endsection

@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="seomodulemanagement"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
    <script>
        $("#product_special_url").change(function(){
            if ($('#product_special_url').prop('checked') == false){
                $('#product_url_format').attr('disabled','disabled');
            } else {
                $('#product_url_format').removeAttr('disabled')
            }
        });
        $("#category_special_url").change(function(){
            if ($('#category_special_url').prop('checked') == false){
                $('#category_url_format').attr('disabled','disabled');
            } else {
                $('#category_url_format').removeAttr('disabled')
            }
        });
        $("#page_special_url").change(function(){
            if ($('#page_special_url').prop('checked') == false){
                $('#page_url_format').attr('disabled','disabled');
            } else {
                $('#page_url_format').removeAttr('disabled')
            }
        });
        $("#brand_special_url").change(function(){
            if ($('#brand_special_url').prop('checked') == false){
                $('#brand_url_format').attr('disabled','disabled');
            } else {
                $('#brand_url_format').removeAttr('disabled')
            }
        });

    </script>
@endsection