<?php

namespace Modules\SEO\SubModules\NoIndex\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class NoIndexServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->hooks();
    }

    public function hooks()
    {
        add_action('frontend.header.meta', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::frontendHeaderMeta');
        add_action('adtrpanel.meta_info_tab.lastrow', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::metaInfoTabAddRow');
        add_action('adtrpanel.brand.save.after', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::brandSaveAfter');
        add_action('adtrpanel.page.save.after', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::pageSaveAfter');
        add_action('adtrpanel.product.save.after', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::productSaveAfter');
        add_action('adtrpanel.category.save.after', 'Modules\SEO\SubModules\NoIndex\Http\Controllers\HooksController::categorySaveAfter');
    }

    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('noindex.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__.'/../Config/config.php', 'noindex'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/noindex');

        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ],'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/noindex';
        }, \Config::get('view.paths')), [$sourcePath]), 'noindex');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/noindex');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'noindex');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'noindex');
        }
    }

    /**
     * Register an additional directory of factories.
     * 
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
