<?php

namespace Modules\SEO\SubModules\NoIndex\Http\Controllers;

use App\Models\ModuleSetting;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */

    public $message = [];
    private $module;
    private $ndata;

    public function __construct()
    {
        $this->module = Module::find('NoIndex');
    }

    public function activate()
    {

        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';

        $this->ndata = ['message_variable' => 'success', 'message' => 'NoIndex Modülü aktif edildi.'];
        return redirect()->back()->with($this->ndata);
    }

    public function remove()
    {

        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function deactivate()
    {
        $type = request()->get('type');
        $this->ndata = ['message_variable' => 'success', 'message' => 'NoIndex Modülü pasif edildi.'];

        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return redirect()->back()->with($this->ndata);
    }

    public function saveSettings()
    {

        if (request()->has('brands_page_noindex') && request('brands_page_noindex') == true) {
            ModuleSetting::updateOrCreate(
                [
                    'module_name' => $this->module->alias,
                    'entry' => "brands_page_noindex"
                ],
                [
                    "value" => trim(request('brands_page_noindex'))
                ]);
        } else {
            ModuleSetting::where('module_name', $this->module->alias)->where('entry', 'brands_page_noindex')->delete();
        }

        if (request()->has('search_page_noindex') && request('search_page_noindex') == true) {
            ModuleSetting::updateOrCreate(
                [
                    'module_name' => $this->module->alias,
                    'entry' => "search_page_noindex"
                ],
                [
                    "value" => trim(request('search_page_noindex'))
                ]);
        } else {
            ModuleSetting::where('module_name', $this->module->alias)->where('entry', 'search_page_noindex')->delete();
        }




        $ndata = ['message_variable' => 'success', 'message' => 'Ayarlarınız kaydedildi'];

        return redirect()->back()->with($ndata);

    }


}
