<?php

namespace Modules\SEO\SubModules\NoIndex\Http\Controllers;

use App\Models\Brand;
use App\Models\Category;
use App\Models\Page;
use App\Models\Product;
use Modules\SEO\SubModules\NoIndex\Entities\NoIndex;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

class HooksController extends Controller
{
    public static function frontendHeaderMeta($data)
    {
        $route_name = request()->route()->getName();
        switch ($route_name)
        {
            case 'brands':
                $status = self::brandNoIndexStatus('all');
                break;
            case 'brands.products':
                $status = self::brandNoIndexStatus($data['data']['brand']);
                break;
            case 'category':
                $status = self::categoryNoIndexStatus($data['data']['category']);
                break;
            case 'product':
                $status = self::productNoIndexStatus($data['data']['product']);
                break;
            case 'page':
                $status = self::pageNoIndexStatus($data['data']['page']);
                break;
            case 'search':
                $status = self::searchNoIndexStatus();
                break;
            default:
                $status = false;
                break;
        }
        if($status == true)
        {
            $data['meta'][] = '<meta name="robots" content="noindex, nofollow">';
        }
        return $data;
    }

    private static function brandNoIndexStatus($brand)
    {
        if($brand != 'all')
        {
            $result = NoIndex::where('type', 'brand')->where('path', $brand->slug)->first();
            if($result)
            {
                return true;
            } else {
                return false;
            }
        } else {
            $result = config('module_settings.noindex.brands_page_noindex', 0);
            if($result == 1)
            {
                return true;
            } else {
                return false;
            }
        }
    }

    private static function categoryNoIndexStatus($category)
    {
        $result = NoIndex::where('type', 'category')->where('path', $category->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function productNoIndexStatus($product)
    {
        $result = NoIndex::where('type', 'product')->where('path', $product->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function pageNoIndexStatus($page)
    {
        $result = NoIndex::where('type', 'page')->where('path', $page->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function searchNoIndexStatus()
    {
        $result = config('module_settings.noindex.search_page_noindex', 0);
        if($result == 1)
        {
            return true;
        } else {
            return false;
        }
    }

    public static function metaInfoTabAddRow($data)
    {
        switch ($data['type'])
        {
            case 'brand':
                if($data['data'] != null)
                {
                    $status = self::brandMetaTabRow($data['data']);
                } else {
                    $status = false;
                }
                break;
            case 'page':
                if($data['data'] != null)
                {
                    $status = self::pageMetaTabRow($data['data']);
                } else {
                    $status = false;
                }
                break;
            case 'product':
                if($data['data'] != null)
                {
                    $status = self::productMetaTabRow($data['data']);
                } else {
                    $status = false;
                }
                break;
            case 'category':
                if($data['data'] != null)
                {
                    $status = self::categoryMetaTabRow($data['data']);
                } else {
                    $status = false;
                }
                break;
            default:
                $status = false;
                break;
        }
        $data['meta'][] = view('noindex::adtrpanel.blades.meta_info_tab', compact('status'))->render();
        return $data;
    }

    private static function brandMetaTabRow($brand)
    {
        $result = NoIndex::where('type', 'brand')->where('path', $brand->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function pageMetaTabRow($page)
    {
        $result = NoIndex::where('type', 'page')->where('path', $page->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function productMetaTabRow($product)
    {
        $result = NoIndex::where('type', 'product')->where('path', $product->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    private static function categoryMetaTabRow($category)
    {
        $result = NoIndex::where('type', 'category')->where('path', $category->slug)->first();
        if($result)
        {
            return true;
        } else {
            return false;
        }
    }

    public static function brandSaveAfter($data)
    {
        if($data['id'] == null)
        {
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::ucreate(
                    [
                        'type' => 'brand',
                        'path' => $data['request']['slug']
                    ]
                );
            }
        } else {
            $brand = Brand::find($data['id']);
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::updateOrCreate(
                    [
                        'type' => 'brand',
                        'path' => $brand->slug
                    ]
                );
            } else {
                NoIndex::where('type', 'brand')->where('path', $brand->slug)->delete();
            }
        }
    }

    public static function pageSaveAfter($data)
    {
        if($data['id'] == null)
        {
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::ucreate(
                    [
                        'type' => 'page',
                        'path' => $data['request']['slug']
                    ]
                );
            }
        } else {
            $page = Page::find($data['id']);
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::updateOrCreate(
                    [
                        'type' => 'page',
                        'path' => $page->slug
                    ]
                );
            } else {
                NoIndex::where('type', 'page')->where('path', $page->slug)->delete();
            }
        }
    }

    public static function productSaveAfter($data)
    {
        if($data['id'] == null)
        {
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::ucreate(
                    [
                        'type' => 'product',
                        'path' => $data['request']['slug']
                    ]
                );
            }
        } else {
            $product = Product::find($data['id']);
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::updateOrCreate(
                    [
                        'type' => 'product',
                        'path' => $product->slug
                    ]
                );
            } else {
                NoIndex::where('type', 'product')->where('path', $product->slug)->delete();
            }
        }
    }

    public static function categorySaveAfter($data)
    {
        if($data['id'] == null)
        {
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::ucreate(
                    [
                        'type' => 'category',
                        'path' => $data['request']['slug']
                    ]
                );
            }
        } else {
            $category = Category::find($data['id']);
            if(array_key_exists('meta_no_index', $data['request']))
            {
                NoIndex::updateOrCreate(
                    [
                        'type' => 'category',
                        'path' => $category->slug
                    ]
                );
            } else {
                NoIndex::where('type', 'category')->where('path', $category->slug)->delete();
            }
        }
    }
}
