@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <section class="page-content">
            <form method="post" action="{{route('adtrpanel.seo.cdn.settings.save')}}">
                {{ csrf_field() }}
                <h1>Ayarlar</h1>
                <div class="text-right">
                    <div class="actions btn-set">
                        <a href=""> <button type="button" name="back" class="btn btn-secondary-outline"><i class="fa fa-angle-left"></i> Geri
                            </button></a>
                        <button type="reset" class="btn btn-secondary-outline"><i class="fa fa-reply"></i> Temizle</button>
                        <button type="submit" name="kaydet" value="1" class="btn btn-success"><i class="fa fa-check"></i> Kaydet</button>
                    </div>
                </div>
                <hr>
                <!--Masaüstü Sekme Linkleri-->
                <div class="desktop-nav-tabs d-none d-sm-none d-lg-block">
                    <ul class="nav nav-tabs product-tabs-select">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="pill" href="#general_info">Genel Bilgiler</a>
                        </li>
                    </ul>
                </div>
                <!--Masaüstü Sekme Linkleri Bitti-->

                <!--Mobil Sekme Linkleri-->
                <div class="d-lg-none d-sm-block tabs-mobile">
                    <select title="Sekme seçiniz" class="mobile-select">
                        <option data-toggle="pill" value="#general_info">Genel Bilgiler</option>
                    </select>
                </div>
                <!--Mobil Sekme Linkleri Bitti-->
                <!-- Tab panes -->
                <div class="tab-content">
                    <div class="tab-pane active" id="general_info">
                        <!--Genel Bilgiler-->
                        <div class="form-group row">
                            <label for="asset_url" class="col-sm-4 col-form-label">CSS ve Javascript Dosyaları İçin Kullanılacak CDN yolu<br /><small><strong>Örnek : </strong>https://cdn-assets.siteniz.com</small></label>
                            <div class="col-sm-6">
                                <input type="text" class="form-control" name="asset_url" @if(config('module_settings.cdn.asset_url')) value="{{config('module_settings.cdn.asset_url')}}" }} @else placeholder="CSS ve Javascript Dosyaları İçin Kullanılacak CDN yolu" @endif>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="asset_image_url" class="col-sm-4 col-form-label">Resim Dosyaları İçin Kullanılacak CDN yolu<br /><small><strong>Örnek : </strong>https://cdn-images.siteniz.com</small></label>
                            <div class="col-sm-6">
                                <input type="text" class="form-control" name="asset_image_url" @if(config('module_settings.cdn.asset_image_url')) value="{{config('module_settings.cdn.asset_image_url')}}" }} @else placeholder="Resim Dosyaları İçin Kullanılacak CDN yolu" @endif>
                            </div>
                        </div>
                        <!--Genel Bilgi Bittiker-->
                    </div>
                </div>
            </form>
        </section>
@endsection