<?php

namespace Modules\SEO\CDN\SiteMap\Http\Controllers;

use App\Models\ModuleSetting;
use Nwidart\Modules\Facades\Module;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ModuleController extends Controller
{
    public $message = [];
    private $module;

    public function __construct()
    {
        $this->module = Module::find('CDN');
    }

    public function activate()
    {
        $this->module->enable();
        $this->message[] = 'Module Aktif Edildi';
        return $this->message;
    }

    public function deactivate()
    {
        $this->message[] = 'Databaseden Tablolar Silindi';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function remove() {
        DB::table('module_settings')->where('module_name', 'like','%'.$this->module->alias.'%')->delete();
        $this->message[] = 'Databaseden Tablolar Kaldırıldı';
        $this->module->disable();
        $this->message[] = 'Module Pasif Edildi';
        return $this->message;
    }

    public function settingsForm() {
        return view('cdn::adtrpanel.settings_form');
    }

    public function saveSettings() {

        $datas = request()->only('asset_url', 'asset_image_url');

        foreach ($datas as $key => $value) {
            $saveSettings = ModuleSetting::updateOrCreate(
                [
                    'module_name' => $this->module->alias,
                    'entry' => $key
                ],
                [
                    'value' => $value
                ]
            );
        }

        if ($saveSettings) {
            $this->message = ['message_variable' => 'success', 'message' => 'Ayarlar kaydedildi'];
        }else {
            $this->message = ['message_variable' => 'warning', 'message' => 'Ayarlar kaydedilemedi'];;
        }

        return redirect()->back()->with($this->message);

    }
}