<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'adtr', 'prefix' => 'adtrpanel'], function () {

    Route::group(['middleware' => 'adtr', 'prefix' => 'seo-modul-yonetimi'], function () {
        //Ödeme Yöntemi İşlemleri
        Route::get('/', 'SEOController@index')->name('adtrpanel.seo.seo_management');

        // DEACTİVATE ROUTES STARTİNG
        Route::get('/deActivate/{moduleName?}', function ($modulName) {

            $type = request('type');

            if ($modulName == "ChangeUrl") {
                return redirect()->route('seo.ChangeUrl.deActivate', $type);
            } elseif ($modulName == "NoIndex") {
                return redirect()->route('seo.NoIndex.deActivate', $type);
            } elseif ($modulName == "Robots") {
                return redirect()->route('seo.Robots.deActivate', $type);
            } elseif ($modulName == "SiteMap") {
                return redirect()->route('seo.SiteMap.deActivate', $type);
            } elseif ($modulName == "SeoImages") {
                return redirect()->route('seo.SeoImages.deActivate', $type);
            } elseif ($modulName == "SiteMap") {
                return redirect()->route('seo.SiteMap.deActivate', $type);
            } elseif ($modulName == "UrlRedirect") {
                return redirect()->route('seo.UrlRedirect.deActivate', $type);
            } elseif ($modulName == "CDN") {
                return redirect()->route('seo.CDN.deActivate', $type);
            } else {
                return redirect('/');
            }
        })->name('adtrpanel.seo.deActivate');


        Route::get('/deActivateUrlRedirect/{type?}', '\Modules\SEO\SubModules\UrlRedirect\Http\Controllers\ModuleController@deactivate')->name('seo.UrlRedirect.deActivate');
        Route::get('/deActivateChangeUrl/{type?}', '\Modules\SEO\SubModules\ChangeUrl\Http\Controllers\ModuleController@deactivate')->name('seo.ChangeUrl.deActivate');
        Route::get('/deActivateRobots/{type?}', '\Modules\SEO\SubModules\Robots\Http\Controllers\ModuleController@deactivate')->name('seo.Robots.deActivate');
        Route::get('/deActivateNoIndex/{type?}', '\Modules\SEO\SubModules\NoIndex\Http\Controllers\ModuleController@deactivate')->name('seo.NoIndex.deActivate');
        Route::get('/deActivateSeoImages/{type?}', '\Modules\SEO\SubModules\SeoImages\Http\Controllers\ModuleController@deactivate')->name('seo.SeoImages.deActivate');
        Route::get('/deActivateSiteMap/{type?}', '\Modules\SEO\SubModules\SiteMap\Http\Controllers\ModuleController@deactivate')->name('seo.SiteMap.deActivate');
        Route::get('/deActivateCDN/{type?}', '\Modules\SEO\SubModules\CDN\Http\Controllers\ModuleController@deactivate')->name('seo.CDN.deActivate');


        // ACTİVATE ROUTES STARTİNG
        Route::get('/Activate/{moduleName?}', function ($modulName) {

            $type = request('type');

            if ($modulName == "ChangeUrl") {
                return redirect()->route('seo.ChangeUrl.Activate', $type);
            } elseif ($modulName == "NoIndex") {
                return redirect()->route('seo.NoIndex.Activate', $type);
            } elseif ($modulName == "Robots") {
                return redirect()->route('seo.Robots.Activate', $type);
            } elseif ($modulName == "SiteMap") {
                return redirect()->route('seo.SiteMap.Activate', $type);
            } elseif ($modulName == "SeoImages") {
                return redirect()->route('seo.SeoImages.Activate', $type);
            } elseif ($modulName == "SiteMap") {
                return redirect()->route('seo.SiteMap.Activate', $type);
            } elseif ($modulName == "UrlRedirect") {
                return redirect()->route('seo.UrlRedirect.Activate', $type);
            } elseif ($modulName == "CDN") {
                return redirect()->route('seo.CDN.Activate', $type);
            } else {
                return redirect('/');
            }
        })->name('adtrpanel.seo.activate');


        Route::get('/ActivateUrlRedirect/{type?}', '\Modules\SEO\SubModules\UrlRedirect\Http\Controllers\ModuleController@activate')->name('seo.UrlRedirect.Activate');
        Route::get('/ActivateChangeUrl/{type?}', '\Modules\SEO\SubModules\ChangeUrl\Http\Controllers\ModuleController@activate')->name('seo.ChangeUrl.Activate');
        Route::get('/ActivateRobots/{type?}', '\Modules\SEO\SubModules\Robots\Http\Controllers\ModuleController@activate')->name('seo.Robots.Activate');
        Route::get('/ActivateNoIndex/{type?}', '\Modules\SEO\SubModules\NoIndex\Http\Controllers\ModuleController@activate')->name('seo.NoIndex.Activate');
        Route::get('/SeoImages/{type?}', '\Modules\SEO\SubModules\SeoImages\Http\Controllers\ModuleController@activate')->name('seo.SeoImages.Activate');
        Route::get('/SiteMap/{type?}', '\Modules\SEO\SubModules\SiteMap\Http\Controllers\ModuleController@activate')->name('seo.SiteMap.Activate');
        Route::get('/CDN/{type?}', '\Modules\SEO\SubModules\CDN\Http\Controllers\ModuleController@activate')->name('seo.CDN.Activate');

        Route::group(['prefix' => '/settings'], function () {
            Route::get('/{modulName?}', function ($modulName) {
                if ($modulName == "ChangeUrl") {
                    return redirect()->route('adtrpanel.seo.change-url.settings_form');
                } elseif ($modulName == "NoIndex") {
                    return redirect()->route('adtrpanel.seo.noindex.settings_form');
                } elseif ($modulName == "SeoImages") {
                    return redirect()->route('adtrpanel.seo.seoimages.settings_form');
                } elseif ($modulName == "SiteMap") {
                    return redirect()->route('adtrpanel.seo.sitemaps.settings_form');
                } elseif ($modulName == "CDN") {
                    return redirect()->route('adtrpanel.seo.cdn.settings_form');
                } else {
                    return redirect('/');
                }
            })->name('adtrpanel.seo.settings');

        });


    });


});