@extends('adtrpanel.layouts.master')
@section('content')
    <!--Header-->
    @include('adtrpanel.partials.header')
    <!--Header Bitti-->
    <!--Sayfa İçeriği-->
    <section class="page-content">
        @include('adtrpanel.partials.errors')
        @include('adtrpanel.partials.alert')
        <h1 class="inner-page-title d-none d-sm-none d-lg-block">SEO Modul Yönetimi</h1>

        <!-- MODÜLLER -->
        <div class="table-responsive">
            <form method="post" action="{{route('adtrpanel.multiaction')}}" id="multiAction">
                {{csrf_field()}}
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th style="width: 15%;">Modul Adı</th>
                        <th style="width: 30%;">Açıklama</th>
                        <th style="width: 10%;">Yazar</th>
                        <th style="width: 10%;">Versiyon</th>
                        <th class="text-center" style="width: 10%;">Durum</th>
                        <th class="text-center" style="width: 10%;">İşlemler</th>
                    </tr>
                    </thead>
                    <tbody id="modulesList">
                    @foreach($modules as $module)
                        @if($module->private == 1 && $module->type == "seotools" && $module->alias != "seo")
                            <tr>
                                <td>{{$module}}</td>
                                <td>{{$module->description}}</td>
                                <td>{{$module->author}}</td>
                                <td class="text-center">{{$module->version}}</td>
                                <td class="text-center">
                                    <h6>
                                        @if($module->active === 1)
                                            <span class="badge badge-success">Aktif</span>
                                        @else
                                            <span class="badge badge-danger">Pasif</span>
                                        @endif
                                    </h6>
                                </td>
                                <td class="text-center">
                                    @if($module->active === 1)
                                        <button onclick="{{$module->settings == true ? "deActivateModule('".$module->name."','true')" : "deActivateModule('".$module->name."')"}}" type="button" class="btn btn-warning" id="deactivateModule" title="Modülü Pasifleştir"><i class="fa fa-lock"></i></button>
                                    @elseif($module->active === 0)
                                        <button onclick="activeModule('{{$module->name}}')" type="button" class="btn btn-success" title="Modülü Aktifleştir"><i class="fa fa-lock-open"></i></button>
                                    @endif

                                    @if($module->active === 1 && $module->settings == true)
                                        <a href="{{ route('adtrpanel.seo.settings', $module->name)}}" class="btn btn-secondary" title="Modül Ayarları"><i class="fa fa-cogs"></i></a>
                                    @endif
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </form>
        </div>
        <!--Ürünler Bitti-->
    </section>
    <!--Sayfa İçeriği Bitti-->
@endsection
@section('css')
@endsection
@section('js')
    <script>
        // Akordion açtırma
        $(document).ready(function () {
            $('*[data-target="#seomanage"]').attr('aria-expanded', 'true');
            $('*[data-active="seomodulemanagement"]').addClass('active');
            $('#seomanage').addClass('show')
        });
    </script>
    <script>
        function activeModule(moduleName) {
            swal({
                title: 'Emin misiniz?',
                text: "Bu modülü aktifleştirmek istediğinize emin misiniz ?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet!',
                cancelButtonText: 'Hayır!'
            }).then((result) => {
                if (result.value) {
                    window.location = "{{ route('adtrpanel.seo.activate') }}/" + moduleName;
                }
            });
        }
    </script>
    <script>
        function deActivateModule(moduleName, setting) {
            swal({
                title: 'Emin misiniz?',
                html: "Bu modülü pasifleştirmek istediğinize emin misiniz ?" +
                    "<hr>" +
                    "<input type='checkbox' id='question' name='question' class='form-check-input'/>" +
                    "<label class='form-check-label' style='color:#d33; font-weight:bold!important;' name='question'/>Tüm ayarlarımı sil ?</label>",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Evet!',
                cancelButtonText: 'Hayır!'
            }).then((result) => {
                if (result.value) {
                    if (setting == "true") {
                        if($('#question').is(':checked')) {
                            window.location = "{{ route('adtrpanel.seo.deActivate') }}/" + moduleName + "?type=1";
                        }else {
                            window.location = "{{ route('adtrpanel.seo.deActivate') }}/"+moduleName;
                        }
                    }else {
                        window.location = "{{ route('adtrpanel.seo.deActivate') }}/"+moduleName;
                    }
                }
            });
        }
    </script>
    <script>
        function formSubmit() {
            var val = $('#multiFormAction option:selected').val();
            if ((val == 'moduleDelete') || (val == 'moduleActivate') || (val == 'moduleDeActivate')) {
                swal({
                    title: 'Emin misiniz?',
                    text: "İşlemi yapmak istediğinize emin misiniz ?",
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Evet!',
                    cancelButtonText: 'Hayır!'
                }).then((result) => {
                    if (result.value) {
                        $('#multiAction').submit();
                    }
                });
            }else {
                $('#multiAction').submit();
            }
        }
    </script>
@endsection
