<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

    Route::get('/', 'HomeController@index')->name('anasayfa');
    Route::get('/urunler', 'ProductController@index')->name('urun');
    Route::get('/urunler/{slug}', 'ProductController@productDetail')->name('urun_detay');
    Route::get('/blog/', 'BlogController@index')->name('blog');
    Route::get('/blog/{slug}','BlogController@blogDetail')->name('blog_detay');
    Route::get('/iletisim', 'ContactController@index');
    Route::post('/sendContact', 'ContactController@ajaxSendContact')->name('ajax.contact');
    Route::get('/bayiler', 'DealerController@index')->name('bayi');
    Route::get('/fotograf-galeri', 'PhotoDetailController@index')->name('fotograf');
    Route::get('/fotograf-galeri/{slug}', 'PhotoDetailController@photoDetail')->name('fotograf-detay');
    Route::get('/video-galeri', 'VideoController@index')->name('video');
    Route::get('/referanslar', 'ReferenceController@index')->name('referans');
    Route::post('/aramayap', 'SearchResultController@index')->name('ara');
    Route::get('/slider','SliderController@index');
    Route::get('/katalog','CatalogController@index')->name('katalog');
    Route::get('/kurumsal','CorporateController@index')->name('kurumsal');
    Route::get('/insan-kaynaklari','HumanResourceController@index')->name('human_resource');
    Route::post('/ajaxComment','AjaxController@sendComment');
    Route::post('/ajaxTechnicalForm','AjaxController@sendTechnicalForm')->name('ajax.technicalForm');
    Route::post('/ajaxBullient','AjaxController@sendBullientForm')->name('ajax.bullient');
    Route::post('/ajaxOffer','AjaxController@sendOfferForm')->name('ajax.offerForm');
    Route::post('/ajaxVideo','AjaxController@sendVideoForm')->name('ajax.video.views');
    Route::post('/rating','AjaxController@sendRating')->name('ajax.rating');
    Route::post('/productRating','AjaxController@sendProductRating')->name('ajax.product.rating');
    Route::post('/cv','CvController@sendCvForm')->name('cv');




