<?php
namespace Modules\Arat\Http\Controllers;

use App\Models\CategoryDetail;
use App\Models\ProductToCategory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use App\Models\Product;
use App\Models\ProductDetail;
use App\Models\ProductImage;

class ProductController extends Controller
{
    public function index(){

        $products = array();
        /*

        $product_to_category = ProductToCategory::all();

        $otomasyon_description = CategoryDetail::where('category_id',2)->select('category_description')->get()[0]['category_description'];
        $card_description = CategoryDetail::where('category_id',1)->select('category_description')->get()[0]['category_description'];
        */
        $categories = CategoryDetail::all();
        if(count($categories) > 0)
        {
            foreach ($categories as $category) {
                $product_to_category = ProductToCategory::where('category_id', $category->category_id)->get();
                $productData = [];
                if(count($product_to_category) > 0)
                {
                    foreach ($product_to_category as $key=>$item){
                        $product = Product::join('product_descriptions','product_id','=','id')->where('id',$item->product_id)->where('products.status',1)->first();
                        if(!is_null($product))
                        {
                            $productData[] = array(
                                'id' => $product['id'],
                                'name' => $product['name'],
                                'image' => $product['image'],
                                'slug'=> $product['slug']
                            );
                        }                        
                    }
                }
                $categoryData[] = array(
                    'category_id' => $category->category_id,
                    'category_name' => $category->category_name,
                    'category_description' => $category->category_description,
                    'slug' => $category->slug,
                    'products' => $productData
                );
                
            }
        }
        

        return view('themes/'. config('site_settings.themes_dir').'/product',compact('categoryData'));
    }

    public function  productDetail($slug){

        $productDetail = ProductDetail::where('slug',$slug)->get()->first();
        $product_data   = Product::where('id',$productDetail['product_id'])->select('model','image','created_at','updated_at')->get();

        $product_id    = $productDetail['product_id'];
        $productName   = $productDetail['name'];
        $seo_description  = $productDetail['seo_description'];

        $count  = $productDetail['count'];

        if($productDetail['count'] == 0){
            $rating = 0;
        }else{
            $rating = $productDetail['rating']/$count;
        }



        $productDescription = $productDetail['description'];
        $word_count = str_word_count($productDescription);
        $product_code  = !empty($product_data[0]['model']) ? $product_data[0]['model'] : '';
        $product_image = $product_data[0]['image'];

        $created_at = $product_data[0]['created_at'];
        $updated_at = $product_data[0]['updated_at'];

        $category_id   = ProductToCategory::where('product_id',$productDetail['product_id'])->select('category_id')->get();
        $category_id   = $category_id[0]['category_id'];
        $category_name = CategoryDetail::where('category_id',$category_id)->select('category_name')->first()->category_name;



        $product_to_category = ProductToCategory::where('category_id',$category_id)->get();

        $otherProducts = array();


        //Kategoriye baglı diğer ürünleri
        foreach ($product_to_category as $id){

            if($id->product_id == $product_id){
                //Ürün detaya basılan id'yi tekrardan kategoriye bağlı urunlerde getirmemek için
            }else{

                $otherProduct = Product::join('product_descriptions','product_id','=','id')->where('product_id',$id->product_id)->where('status',1)->select('id','name','image','slug')->get();

                foreach ($otherProduct as $value){


                    $otherProducts[] = array(
                      'id'    => $value->id,
                      'name'  => $value->name,
                      'image' => $value->image,
                      'slug'  => $value->slug

                    );
                }
            }
        }

        $productImages  = ProductImage::where('product_id',$product_id)->get();

        return view('themes/'. config('site_settings.themes_dir').'/product_detail',compact('rating','count','product_id','word_count' ,'seo_description','product_image','productDetail','productImages','otherProducts','productName','productDescription','product_code','slug','created_at','updated_at','category_name'));
    }

}