<?php

namespace Modules\Arat\Http\Controllers;

use App\Models\BlogDetail;
use App\Models\Menu;
use Carbon\Carbon;
use http\QueryString;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;

use Illuminate\Database\Eloquent\Model;
use App\Models\MenuDetail;

class BlogController extends Controller
{
    public function index($slug = null){


       $page_number = '';
        $page_title_number ='';
       if(count(\request()->all()) > 0){
         $page_number = \request('page') . '.sayfamızda';
         $page_title_number = \request('page') . '.sayfa';
       }


        return view('themes/'. config('site_settings.themes_dir').'/blog/blog',compact('page_number','page_title_number'));
    }

    public function blogDetail($slug){

     //10 10 12 14 15 6  4 5 5  6 6 5 5 4 5 2 1 2 1 => 147
        $blog_detail = BlogDetail::where('slug',$slug)->get();

        $blog = BlogDetail::where('slug',$slug)->first();
        $blog->views =  $blog_detail[0]['views'] +1;
        $blog->save();


        $id = $blog_detail[0]['blog_id'];
        $blog_title = $blog_detail[0]['blog_title'];
        $blog_description = $blog_detail[0]['seo_description'];
        $blog_create_date = $blog_detail[0]['created_at'];
        $blog_update_date = $blog_detail[0]['updated_at'];
        $blog_views = $blog_detail[0]['views'];
        $blog_image = $blog_detail[0]['image'];
        $blog_rating = $blog_detail[0]['rating'];
        $blog_count  = $blog_detail[0]['count'];

        if($blog_detail[0]['count'] == 0){
            $total_rating =  0;

        }else{
            $total_rating =  ($blog_detail[0]['rating'] / $blog_detail[0]['count']);
        }

        $blog_url =  \request()->fullUrl();

        return view('themes/'.config('site_settings.themes_dir').'/blog/blog_detail',compact('total_rating','blog_rating','blog_count','slug','id','blog_title','blog_description','blog_create_date','blog_update_date','blog_views','blog_image','blog_url'));
    }
    public function page($page){
        dd($page);
    }

}