<?php

namespace Modules\Arat\Http\Controllers;

use App\Models\BlogDetail;
use App\Models\BlogIp;
use App\Models\Bullient;
use App\Models\Comment;
use App\Models\Emails;
use App\Models\Offer;
use App\Models\ProductDetail;
use App\Models\ProductIp;
use App\Models\TechnicalForm;
use App\Models\VideoGalleriesDetail;
use http\Message;
use Symfony\Component\HttpKernel\DataCollector\DumpDataCollector;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;


class AjaxController extends Controller
{
    public function sendComment()
    {
        try{
            $result = \request('number1')+\request('number2');

            if($result == \request('captcha')){
                $comment = new Comment();

                $comment->blog_id = request('blog_id');
                $comment->name = request('name');
                $comment->comment = request('comment');
                $comment->email = request('email');
                $comment->save();

                session()->put('success_comment','success_comment');
                session()->put('success_message','Yorumunuz başarılı bir şekilde gönderildi');
            }else{
                session()->put('warning_comment','warning_comment');
                session()->put('warning_message','Dogrulama kodu hatalı girildi. Lütfen dogrulama kodunu kontrol ederek tekrar deneyiniz');
            }


        }catch (\Exception $e){
               session()->put('warning_comment','contact_warning');
        }
        finally{
            return redirect()->back();
        }
    }

    public function sendTechnicalForm(){


        try{

            $technical = new TechnicalForm();

            $technical->adi = request('name');
            $technical->sadi = request('surname');
            $technical->telefon = request('tel');
            $technical->eposta = request('mail');
            $technical->serinum = request('serial_number');

            $technical->mesaj = request('comment') ? request('comment')  : '' ;
            $technical->uruncinsi = request('productType');

            $technical->save();
            session()->put('technicalForm','technicalForm');

            return redirect()->back();
           // $technical->save();
        }catch (\Exception $e){
            session()->put('warning','Teknik servis formu gönderilmedi');
        }
        finally{
            return redirect()->back();
        }
    }

    public function sendBullientForm(){

        try{
            $is_email  = Emails::where('email',request('mail'))->get();

            //veritabanında aynı veriden olup olmadığı kontrol edilir

            //yoksa
            if(count($is_email)==0){
               $mail = new Emails();
               $mail->email = request('mail');
               $mail->save();
                session()->put('success-bullient','success');
            }else{

                session()->put('bullient','warning');

            }

        }catch (\Exception $e){
            session()->put('warning-bullient','warning');
        }
        finally{
            return redirect()->back();
        }
    }

    public function sendOfferForm(){


        try{
            $offer = new Offer();
            $offer->product_name = request('productType');
            $offer->name = request('name');
            $offer->surname = request('surname');
            $offer->phone =request('tel');
            $offer->email = request('mail');
            $offer->comment = request('comment');

            $offer->save();
            if($offer->id)
                session()->put('success_offer','success');
            else
                session()->put('warning_offer','warning');
        }catch (\Exception $e){

        }finally{
            return redirect()->back();
        }
    }
    public function sendVideoForm(){

        $video_views = VideoGalleriesDetail::where('video_details_id',\request('id'))->get();
        $view = VideoGalleriesDetail::where('video_details_id',\request('id'));
        $total = $video_views[0]['views'] + 1 ;
        $view->update(['views' => $total]);
    }

    public function sendRating(){

           $get_ip = $this->GetIP();
           $is_ip = BlogIp::where('blog_id',\request('id'))->where('ip',$get_ip)->get();

           if(count($is_ip)){
               return \response()->json(['warning' => 'Bu blog için daha önceden oy verdiniz.']);
           }else{
               $blog_ip = new BlogIp();
               $blog_ip->blog_id = \request('id');
               $blog_ip->ip = $get_ip;
               $blog_ip->save();

               $rat = BlogDetail::where('blog_id',\request('id'))->select('rating','count')->first();

               $rating = ( $rat->rating +    (int)\request('rate'));
               $count  = ($rat->count + 1);

               $total_rating = $rating;
               $total_count  = $count;

               $result = BlogDetail::where('blog_id',\request('id'))->update(['rating' => $total_rating,'count' => $total_count]);

               return \response()->json(['success'=>'Bu blog\'a oy verdiginiz için teşekkür ederiz']);

           }
    }
    public function sendProductRating(){


            $get_ip = $this->GetIP();
            $is_ip = ProductIp::where('product_id',\request('id'))->where('ip',$get_ip)->get();

            //varsa
            if(count($is_ip) > 0){
                return \response()->json(['warning' => 'Bu ürün için daha önceden oy verdiniz.']);
            }else{

              $ip  = new ProductIp();

              $ip->product_id = \request('id');
              $ip->ip = $get_ip;
              $ip->save();


              $result =  ProductDetail::where('product_id',request('id'))->first();
              $rating = ($result->rating + (double)\request('rating'));
              $count  = ($result->count + 1);

              $update =  ProductDetail::where('product_id',request('id'))->update(['rating' => $rating,'count' => $count]);

                return \response()->json(['success'=>'Bu ürüne\'a oy verdiginiz için teşekkür ederiz']);

            }

    }
    function GetIP(){

        if(getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } elseif(getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
            if (strstr($ip, ',')) {
                $tmp = explode (',', $ip);
                $ip = trim($tmp[0]);
            }
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        return $ip;
    }
}